/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.yaml.swapper;

import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.logging.config.LoggingRuleConfiguration;
import org.apache.shardingsphere.logging.rule.builder.DefaultLoggingRuleConfigurationBuilder;
import org.apache.shardingsphere.logging.yaml.config.YamlAppendersConfigurationConverter;
import org.apache.shardingsphere.logging.yaml.config.YamlLoggersConfigurationConverter;
import org.apache.shardingsphere.logging.yaml.config.YamlLoggingRuleConfiguration;

public final class YamlLoggingRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlLoggingRuleConfiguration, LoggingRuleConfiguration> {
    public YamlLoggingRuleConfiguration swapToYamlConfiguration(LoggingRuleConfiguration data) {
        YamlLoggingRuleConfiguration result = new YamlLoggingRuleConfiguration();
        result.setLoggers(YamlLoggersConfigurationConverter.convertYamlLoggerConfigurations(data.getLoggers()));
        result.setAppenders(YamlAppendersConfigurationConverter.convertYamlAppenderConfigurations(data.getAppenders()));
        return result;
    }

    public LoggingRuleConfiguration swapToObject(YamlLoggingRuleConfiguration yamlConfig) {
        LoggingRuleConfiguration result = new LoggingRuleConfiguration(YamlLoggersConfigurationConverter.convertShardingSphereLogger(yamlConfig.getLoggers()), YamlAppendersConfigurationConverter.convertShardingSphereAppender(yamlConfig.getAppenders()));
        if (null == result.getLoggers()) {
            result = this.getDefaultLoggingRuleConfiguration();
        }
        return result;
    }

    private LoggingRuleConfiguration getDefaultLoggingRuleConfiguration() {
        return new DefaultLoggingRuleConfigurationBuilder().build();
    }

    public Class<LoggingRuleConfiguration> getTypeClass() {
        return LoggingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "LOGGING";
    }

    public int getOrder() {
        return 9100;
    }
}

