/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.yaml.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.nodepath.GlobalNodePath;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlDataNodeGlobalRuleConfigurationSwapper;
import org.apache.shardingsphere.logging.config.LoggingRuleConfiguration;
import org.apache.shardingsphere.logging.rule.builder.DefaultLoggingRuleConfigurationBuilder;
import org.apache.shardingsphere.logging.yaml.config.YamlAppendersConfigurationConverter;
import org.apache.shardingsphere.logging.yaml.config.YamlLoggersConfigurationConverter;
import org.apache.shardingsphere.logging.yaml.config.YamlLoggingRuleConfiguration;

public final class YamlLoggingDataNodeRuleConfigurationSwapper
implements YamlDataNodeGlobalRuleConfigurationSwapper<LoggingRuleConfiguration> {
    public Collection<YamlDataNode> swapToDataNodes(LoggingRuleConfiguration data) {
        return Collections.singletonList(new YamlDataNode(this.getRuleTagName().toLowerCase(), YamlEngine.marshal((Object)this.swapToYamlConfiguration(data))));
    }

    private YamlLoggingRuleConfiguration swapToYamlConfiguration(LoggingRuleConfiguration data) {
        YamlLoggingRuleConfiguration result = new YamlLoggingRuleConfiguration();
        result.setLoggers(YamlLoggersConfigurationConverter.convertYamlLoggerConfigurations(data.getLoggers()));
        result.setAppenders(YamlAppendersConfigurationConverter.convertYamlAppenderConfigurations(data.getAppenders()));
        return result;
    }

    public Optional<LoggingRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        for (YamlDataNode each : dataNodes) {
            Optional version = GlobalNodePath.getVersion((String)this.getRuleTagName().toLowerCase(), (String)each.getKey());
            if (!version.isPresent()) continue;
            return Optional.of(this.swapToObject((YamlLoggingRuleConfiguration)YamlEngine.unmarshal((String)each.getValue(), YamlLoggingRuleConfiguration.class)));
        }
        return Optional.empty();
    }

    private LoggingRuleConfiguration swapToObject(YamlLoggingRuleConfiguration yamlConfig) {
        LoggingRuleConfiguration result = new LoggingRuleConfiguration(YamlLoggersConfigurationConverter.convertShardingSphereLogger(yamlConfig.getLoggers()), YamlAppendersConfigurationConverter.convertShardingSphereAppender(yamlConfig.getAppenders()));
        if (null == result.getLoggers()) {
            result = this.getDefaultLoggingRuleConfiguration();
        }
        return result;
    }

    private LoggingRuleConfiguration getDefaultLoggingRuleConfiguration() {
        return new DefaultLoggingRuleConfigurationBuilder().build();
    }

    public Class<LoggingRuleConfiguration> getTypeClass() {
        return LoggingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "LOGGING";
    }

    public int getOrder() {
        return 9100;
    }
}

