/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.util;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.logging.config.LoggingRuleConfiguration;
import org.apache.shardingsphere.logging.logger.ShardingSphereLogger;
import org.apache.shardingsphere.logging.rule.LoggingRule;

public final class LoggingUtils {
    public static Optional<ShardingSphereLogger> getSQLLogger(RuleMetaData globalRuleMetaData) {
        return globalRuleMetaData.findSingleRule(LoggingRule.class).isPresent() ? LoggingUtils.getSQLLogger(((LoggingRule)globalRuleMetaData.getSingleRule(LoggingRule.class)).getConfiguration()) : Optional.empty();
    }

    public static Optional<ShardingSphereLogger> getSQLLogger(LoggingRuleConfiguration loggingRuleConfig) {
        return loggingRuleConfig.getLoggers().stream().filter(each -> "ShardingSphere-SQL".equalsIgnoreCase(each.getLoggerName())).findFirst();
    }

    public static void syncLoggingConfig(LoggingRuleConfiguration loggingRuleConfig, ConfigurationProperties props) {
        LoggingUtils.getSQLLogger(loggingRuleConfig).ifPresent(option -> {
            Properties loggerProps = option.getProps();
            LoggingUtils.syncPropsToLoggingRule(loggerProps, props);
            LoggingUtils.syncLoggingRuleToProps(loggerProps, props);
        });
    }

    private static void syncPropsToLoggingRule(Properties loggerProps, ConfigurationProperties props) {
        if (!loggerProps.containsKey("enable") && props.getProps().containsKey("sql-show")) {
            loggerProps.setProperty("enable", props.getProps().get("sql-show").toString());
        }
        if (!loggerProps.containsKey("simple") && props.getProps().containsKey("sql-simple")) {
            loggerProps.setProperty("simple", props.getProps().get("sql-simple").toString());
        }
    }

    private static void syncLoggingRuleToProps(Properties loggerProps, ConfigurationProperties props) {
        if (loggerProps.containsKey("enable")) {
            props.getProps().setProperty("sql-show", loggerProps.get("enable").toString());
        }
        if (loggerProps.containsKey("simple")) {
            props.getProps().setProperty("sql-simple", loggerProps.get("simple").toString());
        }
    }

    @Generated
    private LoggingUtils() {
    }
}

