/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.rule.builder;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.rule.builder.global.DefaultGlobalRuleConfigurationBuilder;
import org.apache.shardingsphere.logging.config.LoggingRuleConfiguration;
import org.apache.shardingsphere.logging.logger.ShardingSphereAppender;
import org.apache.shardingsphere.logging.logger.ShardingSphereLogger;
import org.apache.shardingsphere.logging.rule.builder.LoggingRuleBuilder;
import org.slf4j.LoggerFactory;

public final class DefaultLoggingRuleConfigurationBuilder
implements DefaultGlobalRuleConfigurationBuilder<LoggingRuleConfiguration, LoggingRuleBuilder> {
    public LoggingRuleConfiguration build() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        return new LoggingRuleConfiguration(this.getDefaultLoggers(loggerContext), this.getDefaultAppenders(loggerContext));
    }

    private Collection<ShardingSphereLogger> getDefaultLoggers(LoggerContext loggerContext) {
        return loggerContext.getLoggerList().stream().filter(each -> null != each.getLevel()).filter(each -> !"ROOT".equalsIgnoreCase(each.getName())).map(each -> new ShardingSphereLogger(each.getName(), each.getLevel().levelStr, Boolean.valueOf(each.isAdditive()), each.iteratorForAppenders().hasNext() ? ((Appender)each.iteratorForAppenders().next()).getName() : null)).collect(Collectors.toList());
    }

    private Collection<ShardingSphereAppender> getDefaultAppenders(LoggerContext loggerContext) {
        return loggerContext.getLoggerList().stream().filter(each -> null != each.getLevel()).filter(each -> !"ROOT".equalsIgnoreCase(each.getName())).map(each -> {
            Iterator appenderIterator = each.iteratorForAppenders();
            if (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                ShardingSphereAppender shardingSphereAppender = new ShardingSphereAppender(appender.getName(), appender.getClass().getName(), this.getAppenderPattern((Appender<ILoggingEvent>)appender));
                this.getFileOutput((Appender<ILoggingEvent>)appender, shardingSphereAppender);
                return shardingSphereAppender;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new TreeSet<ShardingSphereAppender>(Comparator.comparing(ShardingSphereAppender::getAppenderName))));
    }

    private String getAppenderPattern(Appender<ILoggingEvent> appender) {
        if (appender instanceof OutputStreamAppender) {
            OutputStreamAppender consoleAppender = (OutputStreamAppender)appender;
            LayoutWrappingEncoder encoder = (LayoutWrappingEncoder)consoleAppender.getEncoder();
            PatternLayout layout = (PatternLayout)encoder.getLayout();
            return layout.getPattern();
        }
        return "";
    }

    private void getFileOutput(Appender<ILoggingEvent> appender, ShardingSphereAppender shardingSphereAppender) {
        if (appender instanceof FileAppender) {
            shardingSphereAppender.setFile(((FileAppender)appender).getFile());
        }
    }

    public int getOrder() {
        return 9100;
    }

    public Class<LoggingRuleBuilder> getTypeClass() {
        return LoggingRuleBuilder.class;
    }
}

