/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public final class PropertyUtil {
    private static int springBootVersion = 1;

    public static boolean containPropertyPrefix(Environment environment, String prefix) {
        try {
            Map props = (Map)(1 == springBootVersion ? PropertyUtil.v1(environment, prefix, false) : PropertyUtil.v2(environment, prefix, Map.class));
            return !props.isEmpty();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T> T handle(Environment environment, String prefix, Class<T> targetClass) {
        return (T)(1 == springBootVersion ? PropertyUtil.v1(environment, prefix, true) : PropertyUtil.v2(environment, prefix, targetClass));
    }

    private static Object v1(Environment environment, String prefix, boolean handlePlaceholder) {
        Class<?> resolverClass = Class.forName("org.springframework.boot.bind.RelaxedPropertyResolver");
        Constructor<?> resolverConstructor = resolverClass.getDeclaredConstructor(PropertyResolver.class);
        Method getSubPropertiesMethod = resolverClass.getDeclaredMethod("getSubProperties", String.class);
        Object resolverObject = resolverConstructor.newInstance(environment);
        String prefixParam = prefix.endsWith(".") ? prefix : prefix + ".";
        Method getPropertyMethod = resolverClass.getDeclaredMethod("getProperty", String.class);
        Map dataSourceProps = (Map)getSubPropertiesMethod.invoke(resolverObject, prefixParam);
        HashMap<String, String> result = new HashMap<String, String>(dataSourceProps.size(), 1.0f);
        for (Map.Entry entry : dataSourceProps.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (handlePlaceholder && value instanceof String && ((String)value).contains("${")) {
                String resolvedValue = (String)getPropertyMethod.invoke(resolverObject, prefixParam + key);
                result.put(key, resolvedValue);
                continue;
            }
            result.put(key, (String)value);
        }
        return result;
    }

    private static Object v2(Environment environment, String prefix, Class<?> targetClass) {
        Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
        Method getMethod = binderClass.getDeclaredMethod("get", Environment.class);
        Method bindMethod = binderClass.getDeclaredMethod("bind", String.class, Class.class);
        Object binderObject = getMethod.invoke(null, environment);
        String prefixParam = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        Object bindResultObject = bindMethod.invoke(binderObject, prefixParam, targetClass);
        Method resultGetMethod = bindResultObject.getClass().getDeclaredMethod("get", new Class[0]);
        return resultGetMethod.invoke(bindResultObject, new Object[0]);
    }

    @Generated
    private PropertyUtil() {
    }

    static {
        try {
            Class.forName("org.springframework.boot.bind.RelaxedPropertyResolver");
        }
        catch (ClassNotFoundException ignored) {
            springBootVersion = 2;
        }
    }
}

