/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.datasource.prop.impl;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.spring.boot.datasource.prop.DataSourcePropertiesSetter;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.core.env.Environment;

public final class HikariDataSourcePropertiesSetter
implements DataSourcePropertiesSetter {
    @Override
    public void propertiesSet(Environment environment, String prefix, String dataSourceName, DataSource dataSource) {
        Properties props = new Properties();
        String dataSourcePropKey = prefix + dataSourceName.trim() + ".data-source-properties";
        if (PropertyUtil.containPropertyPrefix(environment, dataSourcePropKey)) {
            Map datasourceProperties = PropertyUtil.handle(environment, dataSourcePropKey, Map.class);
            props.putAll((Map<?, ?>)datasourceProperties);
            Method method = dataSource.getClass().getMethod("setDataSourceProperties", Properties.class);
            method.invoke((Object)dataSource, props);
        }
    }

    @Override
    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }
}

