/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.context;

import com.google.common.eventbus.Subscribe;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.context.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;

public final class JDBCContext {
    private volatile CachedDatabaseMetaData cachedDatabaseMetaData;

    public JDBCContext(Map<String, DataSource> dataSources) throws SQLException {
        this.cachedDatabaseMetaData = this.createCachedDatabaseMetaData(dataSources).orElse(null);
    }

    @Subscribe
    public synchronized void refreshCachedDatabaseMetaData(DataSourceChangedEvent event) throws SQLException {
        this.cachedDatabaseMetaData = this.createCachedDatabaseMetaData(DataSourcePoolCreator.create((Map)event.getDataSourcePropertiesMap())).orElse(null);
    }

    private Optional<CachedDatabaseMetaData> createCachedDatabaseMetaData(Map<String, DataSource> dataSources) throws SQLException {
        if (dataSources.isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSources.values().iterator().next().getConnection();){
            Optional<CachedDatabaseMetaData> optional = Optional.of(new CachedDatabaseMetaData(connection.getMetaData()));
            return optional;
        }
    }

    @Generated
    public CachedDatabaseMetaData getCachedDatabaseMetaData() {
        return this.cachedDatabaseMetaData;
    }
}

