/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.driver.executor.callback.ExecuteQueryCallback;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class DriverJDBCExecutor {
    private final String databaseName;
    private final MetaDataContexts metaDataContexts;
    private final ContextManager contextManager;
    private final JDBCExecutor jdbcExecutor;
    private final MetaDataRefreshEngine metadataRefreshEngine;
    private final EventBusContext eventBusContext;

    public DriverJDBCExecutor(String databaseName, ContextManager contextManager, JDBCExecutor jdbcExecutor) {
        this.databaseName = databaseName;
        this.contextManager = contextManager;
        this.jdbcExecutor = jdbcExecutor;
        this.metaDataContexts = contextManager.getMetaDataContexts();
        this.eventBusContext = contextManager.getInstanceContext().getEventBusContext();
        this.metadataRefreshEngine = new MetaDataRefreshEngine(this.metaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContexts.getMetaData().getProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryResult> executeQuery(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, QueryContext queryContext, ExecuteQueryCallback callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((QueryContext)queryContext, executionGroupContext, (EventBusContext)this.eventBusContext);
            List result = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)callback);
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID(), (EventBusContext)this.eventBusContext);
            List list = result;
            return list;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, QueryContext queryContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Integer> callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((QueryContext)queryContext, executionGroupContext, (EventBusContext)this.eventBusContext);
            SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
            List<Integer> results = this.doExecute(executionGroupContext, sqlStatementContext, routeUnits, callback);
            int result = this.isNeedAccumulate(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules(), sqlStatementContext) ? this.accumulate(results) : results.get(0).intValue();
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID(), (EventBusContext)this.eventBusContext);
            int n = result;
            return n;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private boolean isNeedAccumulate(Collection<ShardingSphereRule> rules, SQLStatementContext<?> sqlStatementContext) {
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof DataNodeContainedRule) || !((DataNodeContainedRule)each).isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    private int accumulate(List<Integer> updateResults) {
        int result = 0;
        for (Integer each : updateResults) {
            result += null != each ? each : 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, QueryContext queryContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Boolean> callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((QueryContext)queryContext, executionGroupContext, (EventBusContext)this.eventBusContext);
            List<Boolean> results = this.doExecute(executionGroupContext, queryContext.getSqlStatementContext(), routeUnits, callback);
            boolean result = null != results && !results.isEmpty() && null != results.get(0) && results.get(0) != false;
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID(), (EventBusContext)this.eventBusContext);
            boolean bl = result;
            return bl;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private <T> List<T> doExecute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<T> callback) throws SQLException {
        List results = this.jdbcExecutor.execute(executionGroupContext, callback);
        this.refreshMetaData(sqlStatementContext, routeUnits);
        return results;
    }

    private void refreshMetaData(SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits) throws SQLException {
        Optional event = this.metadataRefreshEngine.refresh(sqlStatementContext, routeUnits);
        if (this.contextManager.getInstanceContext().isCluster() && event.isPresent()) {
            this.eventBusContext.post(event.get());
        }
    }
}

