/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.api.yaml;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;

public final class YamlShardingSphereDataSourceFactory {
    private static final YamlRuleConfigurationSwapperEngine SWAPPER_ENGINE = new YamlRuleConfigurationSwapperEngine();
    private static final YamlDataSourceConfigurationSwapper DATA_SOURCE_SWAPPER = new YamlDataSourceConfigurationSwapper();

    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlRootConfiguration rootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootConfiguration.class);
        return YamlShardingSphereDataSourceFactory.createDataSource((Map<String, DataSource>)DATA_SOURCE_SWAPPER.swapToDataSources(rootConfig.getDataSources()), rootConfig);
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlRootConfiguration rootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootConfiguration.class);
        return YamlShardingSphereDataSourceFactory.createDataSource((Map<String, DataSource>)DATA_SOURCE_SWAPPER.swapToDataSources(rootConfig.getDataSources()), rootConfig);
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSourceMap, (YamlRootConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootConfiguration.class));
    }

    public static DataSource createDataSource(DataSource dataSource, File yamlFile) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSource, (YamlRootConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootConfiguration.class));
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSourceMap, (YamlRootConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootConfiguration.class));
    }

    public static DataSource createDataSource(DataSource dataSource, byte[] yamlBytes) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSource, (YamlRootConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootConfiguration.class));
    }

    private static DataSource createDataSource(Map<String, DataSource> dataSourceMap, YamlRootConfiguration rootConfig) throws SQLException {
        ModeConfiguration modeConfig = null == rootConfig.getMode() ? null : new YamlModeConfigurationSwapper().swapToObject(rootConfig.getMode());
        Collection ruleConfigs = SWAPPER_ENGINE.swapToRuleConfigurations(rootConfig.getRules());
        return ShardingSphereDataSourceFactory.createDataSource(rootConfig.getDatabaseName(), modeConfig, dataSourceMap, (Collection<RuleConfiguration>)ruleConfigs, rootConfig.getProps());
    }

    private static DataSource createDataSource(DataSource dataSource, YamlRootConfiguration rootConfig) throws SQLException {
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>(Collections.singletonMap(Strings.isNullOrEmpty((String)rootConfig.getDatabaseName()) ? "logic_db" : rootConfig.getDatabaseName(), dataSource));
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSourceMap, rootConfig);
    }

    @Generated
    private YamlShardingSphereDataSourceFactory() {
    }
}

