/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractResultSetAdapter;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ResultSetUtil;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;

public final class ShardingSphereResultSet
extends AbstractResultSetAdapter {
    private static final String ASCII = "Ascii";
    private static final String UNICODE = "Unicode";
    private static final String BINARY = "Binary";
    private final MergedResult mergeResultSet;
    private final Map<String, Integer> columnLabelAndIndexMap;

    public ShardingSphereResultSet(List<ResultSet> resultSets, MergedResult mergeResultSet, Statement statement, ExecutionContext executionContext) throws SQLException {
        super(resultSets, statement, executionContext);
        this.mergeResultSet = mergeResultSet;
        this.columnLabelAndIndexMap = this.createColumnLabelAndIndexMap(resultSets.get(0).getMetaData());
    }

    private Map<String, Integer> createColumnLabelAndIndexMap(ResultSetMetaData resultSetMetaData) throws SQLException {
        CaseInsensitiveMap result = new CaseInsensitiveMap(resultSetMetaData.getColumnCount(), 1.0f);
        for (int columnIndex = resultSetMetaData.getColumnCount(); columnIndex > 0; --columnIndex) {
            result.put(resultSetMetaData.getColumnLabel(columnIndex), columnIndex);
        }
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergeResultSet.next();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.mergeResultSet.wasNull();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Short.TYPE), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Long.TYPE), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Double.TYPE), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, String.class), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, byte[].class), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Date.class), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnIndex, Date.class, cal), Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Time.class), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnIndex, Time.class, cal), Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnIndex, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, ASCII);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, UNICODE);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, BINARY);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.mergeResultSet.getValue(columnIndex, Reader.class);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.mergeResultSet.getValue(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.mergeResultSet.getValue(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return (Array)this.mergeResultSet.getValue(columnIndex, Array.class);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.mergeResultSet.getValue(columnIndex, URL.class);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return (SQLXML)this.mergeResultSet.getValue(columnIndex, SQLXML.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.mergeResultSet.getValue(columnIndex, Object.class);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (LocalDateTime.class.equals(type) || LocalDate.class.equals(type) || LocalTime.class.equals(type)) {
            return (T)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Timestamp.class), type);
        }
        throw new SQLFeatureNotSupportedException("getObject with type");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject((int)this.getIndexFromColumnLabelAndIndexMap(columnLabel), type);
    }

    private Integer getIndexFromColumnLabelAndIndexMap(String columnLabel) throws SQLFeatureNotSupportedException {
        Integer columnIndex = this.columnLabelAndIndexMap.get(columnLabel);
        if (null == columnIndex) {
            throw new SQLFeatureNotSupportedException(String.format("can't get index from columnLabel[%s].", columnLabel));
        }
        return columnIndex;
    }
}

