/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.datasource.metadata;

import java.sql.DatabaseMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import lombok.Generated;

public final class CachedDatabaseMetaData {
    private final String url;
    private final String userName;
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final String driverName;
    private final String driverVersion;
    private final int driverMajorVersion;
    private final int driverMinorVersion;
    private final int databaseMajorVersion;
    private final int databaseMinorVersion;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private final boolean isReadOnly;
    private final boolean allProceduresAreCallable;
    private final boolean allTablesAreSelectable;
    private final boolean nullsAreSortedHigh;
    private final boolean nullsAreSortedLow;
    private final boolean nullsAreSortedAtStart;
    private final boolean nullsAreSortedAtEnd;
    private final boolean usesLocalFiles;
    private final boolean usesLocalFilePerTable;
    private final boolean supportsMixedCaseIdentifiers;
    private final boolean storesUpperCaseIdentifiers;
    private final boolean storesLowerCaseIdentifiers;
    private final boolean storesMixedCaseIdentifiers;
    private final boolean supportsMixedCaseQuotedIdentifiers;
    private final boolean storesUpperCaseQuotedIdentifiers;
    private final boolean storesLowerCaseQuotedIdentifiers;
    private final boolean storesMixedCaseQuotedIdentifiers;
    private final String identifierQuoteString;
    private final String sqlKeywords;
    private final String numericFunctions;
    private final String stringFunctions;
    private final String systemFunctions;
    private final String timeDateFunctions;
    private final String searchStringEscape;
    private final String extraNameCharacters;
    private final boolean supportsAlterTableWithAddColumn;
    private final boolean supportsAlterTableWithDropColumn;
    private final boolean supportsColumnAliasing;
    private final boolean nullPlusNonNullIsNull;
    private final boolean supportsConvert;
    private final boolean supportsTableCorrelationNames;
    private final boolean supportsDifferentTableCorrelationNames;
    private final boolean supportsExpressionsInOrderBy;
    private final boolean supportsOrderByUnrelated;
    private final boolean supportsGroupBy;
    private final boolean supportsGroupByUnrelated;
    private final boolean supportsGroupByBeyondSelect;
    private final boolean supportsLikeEscapeClause;
    private final boolean supportsMultipleResultSets;
    private final boolean supportsMultipleTransactions;
    private final boolean supportsNonNullableColumns;
    private final boolean supportsMinimumSQLGrammar;
    private final boolean supportsCoreSQLGrammar;
    private final boolean supportsExtendedSQLGrammar;
    private final boolean supportsANSI92EntryLevelSQL;
    private final boolean supportsANSI92IntermediateSQL;
    private final boolean supportsANSI92FullSQL;
    private final boolean supportsIntegrityEnhancementFacility;
    private final boolean supportsOuterJoins;
    private final boolean supportsFullOuterJoins;
    private final boolean supportsLimitedOuterJoins;
    private final String schemaTerm;
    private final String procedureTerm;
    private final String catalogTerm;
    private final boolean isCatalogAtStart;
    private final String catalogSeparator;
    private final boolean supportsSchemasInDataManipulation;
    private final boolean supportsSchemasInProcedureCalls;
    private final boolean supportsSchemasInTableDefinitions;
    private final boolean supportsSchemasInIndexDefinitions;
    private final boolean supportsSchemasInPrivilegeDefinitions;
    private final boolean supportsCatalogsInDataManipulation;
    private final boolean supportsCatalogsInProcedureCalls;
    private final boolean supportsCatalogsInTableDefinitions;
    private final boolean supportsCatalogsInIndexDefinitions;
    private final boolean supportsCatalogsInPrivilegeDefinitions;
    private final boolean supportsPositionedDelete;
    private final boolean supportsPositionedUpdate;
    private final boolean supportsSelectForUpdate;
    private final boolean supportsStoredProcedures;
    private final boolean supportsSubqueriesInComparisons;
    private final boolean supportsSubqueriesInExists;
    private final boolean supportsSubqueriesInIns;
    private final boolean supportsSubqueriesInQuantifieds;
    private final boolean supportsCorrelatedSubqueries;
    private final boolean supportsUnion;
    private final boolean supportsUnionAll;
    private final boolean supportsOpenCursorsAcrossCommit;
    private final boolean supportsOpenCursorsAcrossRollback;
    private final boolean supportsOpenStatementsAcrossCommit;
    private final boolean supportsOpenStatementsAcrossRollback;
    private final int maxBinaryLiteralLength;
    private final int maxCharLiteralLength;
    private final int maxColumnNameLength;
    private final int maxColumnsInGroupBy;
    private final int maxColumnsInIndex;
    private final int maxColumnsInOrderBy;
    private final int maxColumnsInSelect;
    private final int maxColumnsInTable;
    private final int maxConnections;
    private final int maxCursorNameLength;
    private final int maxIndexLength;
    private final int maxSchemaNameLength;
    private final int maxProcedureNameLength;
    private final int maxCatalogNameLength;
    private final int maxRowSize;
    private final boolean doesMaxRowSizeIncludeBlobs;
    private final int maxStatementLength;
    private final int maxStatements;
    private final int maxTableNameLength;
    private final int maxTablesInSelect;
    private final int maxUserNameLength;
    private final int defaultTransactionIsolation;
    private final boolean supportsTransactions;
    private final boolean supportsDataDefinitionAndDataManipulationTransactions;
    private final boolean supportsDataManipulationTransactionsOnly;
    private final boolean dataDefinitionCausesTransactionCommit;
    private final boolean dataDefinitionIgnoredInTransactions;
    private final boolean supportsBatchUpdates;
    private final boolean supportsSavepoints;
    private final boolean supportsNamedParameters;
    private final boolean supportsMultipleOpenResults;
    private final boolean supportsGetGeneratedKeys;
    private final int resultSetHoldability;
    private final int sqlStateType;
    private final boolean locatorsUpdateCopy;
    private final boolean supportsStatementPooling;
    private final boolean supportsStoredFunctionsUsingCallSyntax;
    private final boolean autoCommitFailureClosesAllResultSets;
    private final RowIdLifetime rowIdLifetime;
    private final boolean generatedKeyAlwaysReturned;

    public CachedDatabaseMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        this.url = databaseMetaData.getURL();
        this.userName = databaseMetaData.getUserName();
        this.databaseProductName = databaseMetaData.getDatabaseProductName();
        this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
        this.driverName = databaseMetaData.getDriverName();
        this.driverVersion = databaseMetaData.getDriverVersion();
        this.driverMajorVersion = databaseMetaData.getDriverMajorVersion();
        this.driverMinorVersion = databaseMetaData.getDriverMinorVersion();
        this.databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
        this.databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        this.jdbcMajorVersion = databaseMetaData.getJDBCMajorVersion();
        this.jdbcMinorVersion = databaseMetaData.getJDBCMinorVersion();
        this.isReadOnly = databaseMetaData.isReadOnly();
        this.allProceduresAreCallable = databaseMetaData.allProceduresAreCallable();
        this.allTablesAreSelectable = databaseMetaData.allTablesAreSelectable();
        this.nullsAreSortedHigh = databaseMetaData.nullsAreSortedHigh();
        this.nullsAreSortedLow = databaseMetaData.nullsAreSortedLow();
        this.nullsAreSortedAtStart = databaseMetaData.nullsAreSortedAtStart();
        this.nullsAreSortedAtEnd = databaseMetaData.nullsAreSortedAtEnd();
        this.usesLocalFiles = databaseMetaData.usesLocalFiles();
        this.usesLocalFilePerTable = databaseMetaData.usesLocalFilePerTable();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        this.storesUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        this.storesLowerCaseIdentifiers = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCaseIdentifiers = databaseMetaData.storesMixedCaseIdentifiers();
        this.supportsMixedCaseQuotedIdentifiers = databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        this.storesUpperCaseQuotedIdentifiers = databaseMetaData.storesUpperCaseQuotedIdentifiers();
        this.storesLowerCaseQuotedIdentifiers = databaseMetaData.storesLowerCaseQuotedIdentifiers();
        this.storesMixedCaseQuotedIdentifiers = databaseMetaData.storesMixedCaseQuotedIdentifiers();
        this.identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
        this.sqlKeywords = databaseMetaData.getSQLKeywords();
        this.numericFunctions = databaseMetaData.getNumericFunctions();
        this.stringFunctions = databaseMetaData.getStringFunctions();
        this.systemFunctions = databaseMetaData.getSystemFunctions();
        this.timeDateFunctions = databaseMetaData.getTimeDateFunctions();
        this.searchStringEscape = databaseMetaData.getSearchStringEscape();
        this.extraNameCharacters = databaseMetaData.getExtraNameCharacters();
        this.supportsAlterTableWithAddColumn = databaseMetaData.supportsAlterTableWithAddColumn();
        this.supportsAlterTableWithDropColumn = databaseMetaData.supportsAlterTableWithDropColumn();
        this.supportsColumnAliasing = databaseMetaData.supportsColumnAliasing();
        this.nullPlusNonNullIsNull = databaseMetaData.nullPlusNonNullIsNull();
        this.supportsConvert = databaseMetaData.supportsConvert();
        this.supportsTableCorrelationNames = databaseMetaData.supportsTableCorrelationNames();
        this.supportsDifferentTableCorrelationNames = databaseMetaData.supportsDifferentTableCorrelationNames();
        this.supportsExpressionsInOrderBy = databaseMetaData.supportsExpressionsInOrderBy();
        this.supportsOrderByUnrelated = databaseMetaData.supportsOrderByUnrelated();
        this.supportsGroupBy = databaseMetaData.supportsGroupBy();
        this.supportsGroupByUnrelated = databaseMetaData.supportsGroupByUnrelated();
        this.supportsGroupByBeyondSelect = databaseMetaData.supportsGroupByBeyondSelect();
        this.supportsLikeEscapeClause = databaseMetaData.supportsLikeEscapeClause();
        this.supportsMultipleResultSets = databaseMetaData.supportsMultipleResultSets();
        this.supportsMultipleTransactions = databaseMetaData.supportsMultipleTransactions();
        this.supportsNonNullableColumns = databaseMetaData.supportsNonNullableColumns();
        this.supportsMinimumSQLGrammar = databaseMetaData.supportsMinimumSQLGrammar();
        this.supportsCoreSQLGrammar = databaseMetaData.supportsCoreSQLGrammar();
        this.supportsExtendedSQLGrammar = databaseMetaData.supportsExtendedSQLGrammar();
        this.supportsANSI92EntryLevelSQL = databaseMetaData.supportsANSI92EntryLevelSQL();
        this.supportsANSI92IntermediateSQL = databaseMetaData.supportsANSI92IntermediateSQL();
        this.supportsANSI92FullSQL = databaseMetaData.supportsANSI92FullSQL();
        this.supportsIntegrityEnhancementFacility = databaseMetaData.supportsIntegrityEnhancementFacility();
        this.supportsOuterJoins = databaseMetaData.supportsOuterJoins();
        this.supportsFullOuterJoins = databaseMetaData.supportsFullOuterJoins();
        this.supportsLimitedOuterJoins = databaseMetaData.supportsLimitedOuterJoins();
        this.schemaTerm = databaseMetaData.getSchemaTerm();
        this.procedureTerm = databaseMetaData.getProcedureTerm();
        this.catalogTerm = databaseMetaData.getCatalogTerm();
        this.isCatalogAtStart = databaseMetaData.isCatalogAtStart();
        this.catalogSeparator = databaseMetaData.getCatalogSeparator();
        this.supportsSchemasInDataManipulation = databaseMetaData.supportsSchemasInDataManipulation();
        this.supportsSchemasInProcedureCalls = databaseMetaData.supportsSchemasInProcedureCalls();
        this.supportsSchemasInTableDefinitions = databaseMetaData.supportsSchemasInTableDefinitions();
        this.supportsSchemasInIndexDefinitions = databaseMetaData.supportsSchemasInIndexDefinitions();
        this.supportsSchemasInPrivilegeDefinitions = databaseMetaData.supportsSchemasInPrivilegeDefinitions();
        this.supportsCatalogsInDataManipulation = databaseMetaData.supportsCatalogsInDataManipulation();
        this.supportsCatalogsInProcedureCalls = databaseMetaData.supportsCatalogsInProcedureCalls();
        this.supportsCatalogsInTableDefinitions = databaseMetaData.supportsCatalogsInTableDefinitions();
        this.supportsCatalogsInIndexDefinitions = databaseMetaData.supportsCatalogsInIndexDefinitions();
        this.supportsCatalogsInPrivilegeDefinitions = databaseMetaData.supportsCatalogsInPrivilegeDefinitions();
        this.supportsPositionedDelete = databaseMetaData.supportsPositionedDelete();
        this.supportsPositionedUpdate = databaseMetaData.supportsPositionedUpdate();
        this.supportsSelectForUpdate = databaseMetaData.supportsSelectForUpdate();
        this.supportsStoredProcedures = databaseMetaData.supportsStoredProcedures();
        this.supportsSubqueriesInComparisons = databaseMetaData.supportsSubqueriesInComparisons();
        this.supportsSubqueriesInExists = databaseMetaData.supportsSubqueriesInExists();
        this.supportsSubqueriesInIns = databaseMetaData.supportsSubqueriesInIns();
        this.supportsSubqueriesInQuantifieds = databaseMetaData.supportsSubqueriesInQuantifieds();
        this.supportsCorrelatedSubqueries = databaseMetaData.supportsCorrelatedSubqueries();
        this.supportsUnion = databaseMetaData.supportsUnion();
        this.supportsUnionAll = databaseMetaData.supportsUnionAll();
        this.supportsOpenCursorsAcrossCommit = databaseMetaData.supportsOpenCursorsAcrossCommit();
        this.supportsOpenCursorsAcrossRollback = databaseMetaData.supportsOpenCursorsAcrossRollback();
        this.supportsOpenStatementsAcrossCommit = databaseMetaData.supportsOpenStatementsAcrossCommit();
        this.supportsOpenStatementsAcrossRollback = databaseMetaData.supportsOpenStatementsAcrossRollback();
        this.maxBinaryLiteralLength = databaseMetaData.getMaxBinaryLiteralLength();
        this.maxCharLiteralLength = databaseMetaData.getMaxCharLiteralLength();
        this.maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
        this.maxColumnsInGroupBy = databaseMetaData.getMaxColumnsInGroupBy();
        this.maxColumnsInIndex = databaseMetaData.getMaxColumnsInIndex();
        this.maxColumnsInOrderBy = databaseMetaData.getMaxColumnsInOrderBy();
        this.maxColumnsInSelect = databaseMetaData.getMaxColumnsInSelect();
        this.maxColumnsInTable = databaseMetaData.getMaxColumnsInTable();
        this.maxConnections = databaseMetaData.getMaxConnections();
        this.maxCursorNameLength = databaseMetaData.getMaxCursorNameLength();
        this.maxIndexLength = databaseMetaData.getMaxIndexLength();
        this.maxSchemaNameLength = databaseMetaData.getMaxSchemaNameLength();
        this.maxProcedureNameLength = databaseMetaData.getMaxProcedureNameLength();
        this.maxCatalogNameLength = databaseMetaData.getMaxCatalogNameLength();
        this.maxRowSize = databaseMetaData.getMaxRowSize();
        this.doesMaxRowSizeIncludeBlobs = databaseMetaData.doesMaxRowSizeIncludeBlobs();
        this.maxStatementLength = databaseMetaData.getMaxStatementLength();
        this.maxStatements = databaseMetaData.getMaxStatements();
        this.maxTableNameLength = databaseMetaData.getMaxTableNameLength();
        this.maxTablesInSelect = databaseMetaData.getMaxTablesInSelect();
        this.maxUserNameLength = databaseMetaData.getMaxUserNameLength();
        this.defaultTransactionIsolation = databaseMetaData.getDefaultTransactionIsolation();
        this.supportsTransactions = databaseMetaData.supportsTransactions();
        this.supportsDataDefinitionAndDataManipulationTransactions = databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions();
        this.supportsDataManipulationTransactionsOnly = databaseMetaData.supportsDataManipulationTransactionsOnly();
        this.dataDefinitionCausesTransactionCommit = databaseMetaData.dataDefinitionCausesTransactionCommit();
        this.dataDefinitionIgnoredInTransactions = databaseMetaData.dataDefinitionIgnoredInTransactions();
        this.supportsBatchUpdates = databaseMetaData.supportsBatchUpdates();
        this.supportsSavepoints = databaseMetaData.supportsSavepoints();
        this.supportsNamedParameters = databaseMetaData.supportsNamedParameters();
        this.supportsMultipleOpenResults = databaseMetaData.supportsMultipleOpenResults();
        this.supportsGetGeneratedKeys = databaseMetaData.supportsGetGeneratedKeys();
        this.resultSetHoldability = databaseMetaData.getResultSetHoldability();
        this.sqlStateType = databaseMetaData.getSQLStateType();
        this.locatorsUpdateCopy = databaseMetaData.locatorsUpdateCopy();
        this.supportsStatementPooling = databaseMetaData.supportsStatementPooling();
        this.supportsStoredFunctionsUsingCallSyntax = databaseMetaData.supportsStoredFunctionsUsingCallSyntax();
        this.autoCommitFailureClosesAllResultSets = databaseMetaData.autoCommitFailureClosesAllResultSets();
        this.rowIdLifetime = this.getRowIdLifetimeFromOriginMetaData(databaseMetaData);
        this.generatedKeyAlwaysReturned = this.isGeneratedKeyAlwaysReturned(databaseMetaData);
    }

    private RowIdLifetime getRowIdLifetimeFromOriginMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.getRowIdLifetime();
        }
        catch (SQLFeatureNotSupportedException ignore) {
            return RowIdLifetime.ROWID_UNSUPPORTED;
        }
    }

    private boolean isGeneratedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.generatedKeyAlwaysReturned();
        }
        catch (AbstractMethodError ignore) {
            return false;
        }
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Generated
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Generated
    public String getDriverName() {
        return this.driverName;
    }

    @Generated
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Generated
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Generated
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Generated
    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Generated
    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Generated
    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Generated
    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Generated
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Generated
    public boolean isAllProceduresAreCallable() {
        return this.allProceduresAreCallable;
    }

    @Generated
    public boolean isAllTablesAreSelectable() {
        return this.allTablesAreSelectable;
    }

    @Generated
    public boolean isNullsAreSortedHigh() {
        return this.nullsAreSortedHigh;
    }

    @Generated
    public boolean isNullsAreSortedLow() {
        return this.nullsAreSortedLow;
    }

    @Generated
    public boolean isNullsAreSortedAtStart() {
        return this.nullsAreSortedAtStart;
    }

    @Generated
    public boolean isNullsAreSortedAtEnd() {
        return this.nullsAreSortedAtEnd;
    }

    @Generated
    public boolean isUsesLocalFiles() {
        return this.usesLocalFiles;
    }

    @Generated
    public boolean isUsesLocalFilePerTable() {
        return this.usesLocalFilePerTable;
    }

    @Generated
    public boolean isSupportsMixedCaseIdentifiers() {
        return this.supportsMixedCaseIdentifiers;
    }

    @Generated
    public boolean isStoresUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    @Generated
    public boolean isStoresLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    @Generated
    public boolean isStoresMixedCaseIdentifiers() {
        return this.storesMixedCaseIdentifiers;
    }

    @Generated
    public boolean isSupportsMixedCaseQuotedIdentifiers() {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    @Generated
    public boolean isStoresUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    @Generated
    public boolean isStoresLowerCaseQuotedIdentifiers() {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    @Generated
    public boolean isStoresMixedCaseQuotedIdentifiers() {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    @Generated
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Generated
    public String getSqlKeywords() {
        return this.sqlKeywords;
    }

    @Generated
    public String getNumericFunctions() {
        return this.numericFunctions;
    }

    @Generated
    public String getStringFunctions() {
        return this.stringFunctions;
    }

    @Generated
    public String getSystemFunctions() {
        return this.systemFunctions;
    }

    @Generated
    public String getTimeDateFunctions() {
        return this.timeDateFunctions;
    }

    @Generated
    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    @Generated
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Generated
    public boolean isSupportsAlterTableWithAddColumn() {
        return this.supportsAlterTableWithAddColumn;
    }

    @Generated
    public boolean isSupportsAlterTableWithDropColumn() {
        return this.supportsAlterTableWithDropColumn;
    }

    @Generated
    public boolean isSupportsColumnAliasing() {
        return this.supportsColumnAliasing;
    }

    @Generated
    public boolean isNullPlusNonNullIsNull() {
        return this.nullPlusNonNullIsNull;
    }

    @Generated
    public boolean isSupportsConvert() {
        return this.supportsConvert;
    }

    @Generated
    public boolean isSupportsTableCorrelationNames() {
        return this.supportsTableCorrelationNames;
    }

    @Generated
    public boolean isSupportsDifferentTableCorrelationNames() {
        return this.supportsDifferentTableCorrelationNames;
    }

    @Generated
    public boolean isSupportsExpressionsInOrderBy() {
        return this.supportsExpressionsInOrderBy;
    }

    @Generated
    public boolean isSupportsOrderByUnrelated() {
        return this.supportsOrderByUnrelated;
    }

    @Generated
    public boolean isSupportsGroupBy() {
        return this.supportsGroupBy;
    }

    @Generated
    public boolean isSupportsGroupByUnrelated() {
        return this.supportsGroupByUnrelated;
    }

    @Generated
    public boolean isSupportsGroupByBeyondSelect() {
        return this.supportsGroupByBeyondSelect;
    }

    @Generated
    public boolean isSupportsLikeEscapeClause() {
        return this.supportsLikeEscapeClause;
    }

    @Generated
    public boolean isSupportsMultipleResultSets() {
        return this.supportsMultipleResultSets;
    }

    @Generated
    public boolean isSupportsMultipleTransactions() {
        return this.supportsMultipleTransactions;
    }

    @Generated
    public boolean isSupportsNonNullableColumns() {
        return this.supportsNonNullableColumns;
    }

    @Generated
    public boolean isSupportsMinimumSQLGrammar() {
        return this.supportsMinimumSQLGrammar;
    }

    @Generated
    public boolean isSupportsCoreSQLGrammar() {
        return this.supportsCoreSQLGrammar;
    }

    @Generated
    public boolean isSupportsExtendedSQLGrammar() {
        return this.supportsExtendedSQLGrammar;
    }

    @Generated
    public boolean isSupportsANSI92EntryLevelSQL() {
        return this.supportsANSI92EntryLevelSQL;
    }

    @Generated
    public boolean isSupportsANSI92IntermediateSQL() {
        return this.supportsANSI92IntermediateSQL;
    }

    @Generated
    public boolean isSupportsANSI92FullSQL() {
        return this.supportsANSI92FullSQL;
    }

    @Generated
    public boolean isSupportsIntegrityEnhancementFacility() {
        return this.supportsIntegrityEnhancementFacility;
    }

    @Generated
    public boolean isSupportsOuterJoins() {
        return this.supportsOuterJoins;
    }

    @Generated
    public boolean isSupportsFullOuterJoins() {
        return this.supportsFullOuterJoins;
    }

    @Generated
    public boolean isSupportsLimitedOuterJoins() {
        return this.supportsLimitedOuterJoins;
    }

    @Generated
    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    @Generated
    public String getProcedureTerm() {
        return this.procedureTerm;
    }

    @Generated
    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    @Generated
    public boolean isCatalogAtStart() {
        return this.isCatalogAtStart;
    }

    @Generated
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @Generated
    public boolean isSupportsSchemasInDataManipulation() {
        return this.supportsSchemasInDataManipulation;
    }

    @Generated
    public boolean isSupportsSchemasInProcedureCalls() {
        return this.supportsSchemasInProcedureCalls;
    }

    @Generated
    public boolean isSupportsSchemasInTableDefinitions() {
        return this.supportsSchemasInTableDefinitions;
    }

    @Generated
    public boolean isSupportsSchemasInIndexDefinitions() {
        return this.supportsSchemasInIndexDefinitions;
    }

    @Generated
    public boolean isSupportsSchemasInPrivilegeDefinitions() {
        return this.supportsSchemasInPrivilegeDefinitions;
    }

    @Generated
    public boolean isSupportsCatalogsInDataManipulation() {
        return this.supportsCatalogsInDataManipulation;
    }

    @Generated
    public boolean isSupportsCatalogsInProcedureCalls() {
        return this.supportsCatalogsInProcedureCalls;
    }

    @Generated
    public boolean isSupportsCatalogsInTableDefinitions() {
        return this.supportsCatalogsInTableDefinitions;
    }

    @Generated
    public boolean isSupportsCatalogsInIndexDefinitions() {
        return this.supportsCatalogsInIndexDefinitions;
    }

    @Generated
    public boolean isSupportsCatalogsInPrivilegeDefinitions() {
        return this.supportsCatalogsInPrivilegeDefinitions;
    }

    @Generated
    public boolean isSupportsPositionedDelete() {
        return this.supportsPositionedDelete;
    }

    @Generated
    public boolean isSupportsPositionedUpdate() {
        return this.supportsPositionedUpdate;
    }

    @Generated
    public boolean isSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    @Generated
    public boolean isSupportsStoredProcedures() {
        return this.supportsStoredProcedures;
    }

    @Generated
    public boolean isSupportsSubqueriesInComparisons() {
        return this.supportsSubqueriesInComparisons;
    }

    @Generated
    public boolean isSupportsSubqueriesInExists() {
        return this.supportsSubqueriesInExists;
    }

    @Generated
    public boolean isSupportsSubqueriesInIns() {
        return this.supportsSubqueriesInIns;
    }

    @Generated
    public boolean isSupportsSubqueriesInQuantifieds() {
        return this.supportsSubqueriesInQuantifieds;
    }

    @Generated
    public boolean isSupportsCorrelatedSubqueries() {
        return this.supportsCorrelatedSubqueries;
    }

    @Generated
    public boolean isSupportsUnion() {
        return this.supportsUnion;
    }

    @Generated
    public boolean isSupportsUnionAll() {
        return this.supportsUnionAll;
    }

    @Generated
    public boolean isSupportsOpenCursorsAcrossCommit() {
        return this.supportsOpenCursorsAcrossCommit;
    }

    @Generated
    public boolean isSupportsOpenCursorsAcrossRollback() {
        return this.supportsOpenCursorsAcrossRollback;
    }

    @Generated
    public boolean isSupportsOpenStatementsAcrossCommit() {
        return this.supportsOpenStatementsAcrossCommit;
    }

    @Generated
    public boolean isSupportsOpenStatementsAcrossRollback() {
        return this.supportsOpenStatementsAcrossRollback;
    }

    @Generated
    public int getMaxBinaryLiteralLength() {
        return this.maxBinaryLiteralLength;
    }

    @Generated
    public int getMaxCharLiteralLength() {
        return this.maxCharLiteralLength;
    }

    @Generated
    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    @Generated
    public int getMaxColumnsInGroupBy() {
        return this.maxColumnsInGroupBy;
    }

    @Generated
    public int getMaxColumnsInIndex() {
        return this.maxColumnsInIndex;
    }

    @Generated
    public int getMaxColumnsInOrderBy() {
        return this.maxColumnsInOrderBy;
    }

    @Generated
    public int getMaxColumnsInSelect() {
        return this.maxColumnsInSelect;
    }

    @Generated
    public int getMaxColumnsInTable() {
        return this.maxColumnsInTable;
    }

    @Generated
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Generated
    public int getMaxCursorNameLength() {
        return this.maxCursorNameLength;
    }

    @Generated
    public int getMaxIndexLength() {
        return this.maxIndexLength;
    }

    @Generated
    public int getMaxSchemaNameLength() {
        return this.maxSchemaNameLength;
    }

    @Generated
    public int getMaxProcedureNameLength() {
        return this.maxProcedureNameLength;
    }

    @Generated
    public int getMaxCatalogNameLength() {
        return this.maxCatalogNameLength;
    }

    @Generated
    public int getMaxRowSize() {
        return this.maxRowSize;
    }

    @Generated
    public boolean isDoesMaxRowSizeIncludeBlobs() {
        return this.doesMaxRowSizeIncludeBlobs;
    }

    @Generated
    public int getMaxStatementLength() {
        return this.maxStatementLength;
    }

    @Generated
    public int getMaxStatements() {
        return this.maxStatements;
    }

    @Generated
    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    @Generated
    public int getMaxTablesInSelect() {
        return this.maxTablesInSelect;
    }

    @Generated
    public int getMaxUserNameLength() {
        return this.maxUserNameLength;
    }

    @Generated
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Generated
    public boolean isSupportsTransactions() {
        return this.supportsTransactions;
    }

    @Generated
    public boolean isSupportsDataDefinitionAndDataManipulationTransactions() {
        return this.supportsDataDefinitionAndDataManipulationTransactions;
    }

    @Generated
    public boolean isSupportsDataManipulationTransactionsOnly() {
        return this.supportsDataManipulationTransactionsOnly;
    }

    @Generated
    public boolean isDataDefinitionCausesTransactionCommit() {
        return this.dataDefinitionCausesTransactionCommit;
    }

    @Generated
    public boolean isDataDefinitionIgnoredInTransactions() {
        return this.dataDefinitionIgnoredInTransactions;
    }

    @Generated
    public boolean isSupportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Generated
    public boolean isSupportsSavepoints() {
        return this.supportsSavepoints;
    }

    @Generated
    public boolean isSupportsNamedParameters() {
        return this.supportsNamedParameters;
    }

    @Generated
    public boolean isSupportsMultipleOpenResults() {
        return this.supportsMultipleOpenResults;
    }

    @Generated
    public boolean isSupportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    @Generated
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Generated
    public int getSqlStateType() {
        return this.sqlStateType;
    }

    @Generated
    public boolean isLocatorsUpdateCopy() {
        return this.locatorsUpdateCopy;
    }

    @Generated
    public boolean isSupportsStatementPooling() {
        return this.supportsStatementPooling;
    }

    @Generated
    public boolean isSupportsStoredFunctionsUsingCallSyntax() {
        return this.supportsStoredFunctionsUsingCallSyntax;
    }

    @Generated
    public boolean isAutoCommitFailureClosesAllResultSets() {
        return this.autoCommitFailureClosesAllResultSets;
    }

    @Generated
    public RowIdLifetime getRowIdLifetime() {
        return this.rowIdLifetime;
    }

    @Generated
    public boolean isGeneratedKeyAlwaysReturned() {
        return this.generatedKeyAlwaysReturned;
    }
}

