/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.adapter.invocation.MethodInvocationRecorder;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.transaction.ConnectionTransaction;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class ConnectionManager
implements ExecutorJDBCManager,
AutoCloseable {
    private final Map<String, DataSource> dataSourceMap;
    private final ConnectionTransaction connectionTransaction;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final MethodInvocationRecorder methodInvocationRecorder = new MethodInvocationRecorder();
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();
    private final Random random = new SecureRandom();

    public ConnectionManager(String schema, ContextManager contextManager) {
        this.dataSourceMap = contextManager.getDataSourceMap(schema);
        this.connectionTransaction = this.createConnectionTransaction(schema, contextManager);
    }

    private ConnectionTransaction createConnectionTransaction(String schemaName, ContextManager contextManager) {
        Optional transactionRule = contextManager.getMetaDataContexts().getGlobalRuleMetaData().findSingleRule(TransactionRule.class);
        return transactionRule.map(optional -> new ConnectionTransaction(schemaName, optional, contextManager.getTransactionContexts())).orElseGet(() -> new ConnectionTransaction(schemaName, contextManager.getTransactionContexts()));
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.methodInvocationRecorder.record(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{autoCommit});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setAutoCommit(autoCommit));
    }

    public void commit() throws SQLException {
        if (this.connectionTransaction.isLocalTransaction()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::commit);
        } else {
            this.connectionTransaction.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connectionTransaction.isLocalTransaction()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::rollback);
        } else {
            this.connectionTransaction.rollback();
        }
    }

    public Optional<Integer> getTransactionIsolation() throws SQLException {
        return this.cachedConnections.values().isEmpty() ? Optional.empty() : Optional.of(((Connection)this.cachedConnections.values().iterator().next()).getTransactionIsolation());
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.methodInvocationRecorder.record(Connection.class, "setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{level});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setTransactionIsolation(level));
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.methodInvocationRecorder.record(Connection.class, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{readOnly});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setReadOnly(readOnly));
    }

    public boolean isValid(int timeout) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            if (each.isValid(timeout)) continue;
            return false;
        }
        return true;
    }

    public String getRandomPhysicalDataSourceName() {
        Set datasourceNames = this.cachedConnections.isEmpty() ? this.dataSourceMap.keySet() : this.cachedConnections.keySet();
        return (String)new ArrayList(datasourceNames).get(this.random.nextInt(datasourceNames.size()));
    }

    public Connection getRandomConnection() throws SQLException {
        return this.getConnections(this.getRandomPhysicalDataSourceName(), 1, ConnectionMode.MEMORY_STRICTLY).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        DataSource dataSource = this.dataSourceMap.get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the data source name: '%s'", (Object)dataSourceName);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createConnections(dataSourceName, dataSource, connectionSize - connections.size(), connectionMode);
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = new ArrayList<Connection>(this.createConnections(dataSourceName, dataSource, connectionSize, connectionMode));
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> createConnections(String dataSourceName, DataSource dataSource, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        if (1 == connectionSize) {
            Connection connection = this.createConnection(dataSourceName, dataSource);
            this.methodInvocationRecorder.replay(connection);
            return Collections.singletonList(connection);
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(dataSourceName, dataSource, connectionSize);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(dataSourceName, dataSource, connectionSize);
        }
    }

    private List<Connection> createConnections(String dataSourceName, DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                Connection connection = this.createConnection(dataSourceName, dataSource);
                this.methodInvocationRecorder.replay(connection);
                result.add(connection);
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Can not get %d connections one time, partition succeed connection(%d) have released!", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    private Connection createConnection(String dataSourceName, DataSource dataSource) throws SQLException {
        Optional connectionInTransaction = this.connectionTransaction.getConnection(dataSourceName);
        return connectionInTransaction.isPresent() ? (Connection)connectionInTransaction.get() : dataSource.getConnection();
    }

    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        return connection.createStatement(option.getResultSetType(), option.getResultSetConcurrency(), option.getResultSetHoldability());
    }

    public PreparedStatement createStorageResource(String sql, List<Object> parameters, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        return option.isReturnGeneratedKeys() ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, option.getResultSetType(), option.getResultSetConcurrency(), option.getResultSetHoldability());
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::close);
        }
        finally {
            this.cachedConnections.clear();
        }
    }

    @Generated
    public ConnectionTransaction getConnectionTransaction() {
        return this.connectionTransaction;
    }
}

