/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.url.core.arg;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.url.core.arg.URLArgumentPlaceholderType;

public final class URLArgumentLine {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\$\\{(.+::.*)}$");
    private static final String KV_SEPARATOR = "::";
    private final String argName;
    private final String argDefaultValue;
    private final Matcher placeholderMatcher;

    public static Optional<URLArgumentLine> parse(String line) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(line);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String[] parsedArg = matcher.group(1).split(KV_SEPARATOR, 2);
        return Optional.of(new URLArgumentLine(parsedArg[0], parsedArg[1], matcher));
    }

    public String replaceArgument(URLArgumentPlaceholderType type) {
        String argumentValue = this.getArgumentValue(type);
        if (!Strings.isNullOrEmpty((String)argumentValue)) {
            return this.placeholderMatcher.replaceAll(argumentValue);
        }
        if (!this.argDefaultValue.isEmpty()) {
            return this.placeholderMatcher.replaceAll(this.argDefaultValue);
        }
        String modifiedLineWithSpace = this.placeholderMatcher.replaceAll("");
        return modifiedLineWithSpace.substring(0, modifiedLineWithSpace.length() - 1);
    }

    private String getArgumentValue(URLArgumentPlaceholderType type) {
        if (URLArgumentPlaceholderType.ENVIRONMENT == type) {
            return System.getenv(this.argName);
        }
        if (URLArgumentPlaceholderType.SYSTEM_PROPS == type) {
            return System.getProperty(this.argName);
        }
        return null;
    }

    @Generated
    private URLArgumentLine(String argName, String argDefaultValue, Matcher placeholderMatcher) {
        this.argName = argName;
        this.argDefaultValue = argDefaultValue;
        this.placeholderMatcher = placeholderMatcher;
    }
}

