/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.metadata.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.refresher.FederationMetaDataRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class CreateTableFederationMetaDataRefresher
implements FederationMetaDataRefresher<CreateTableStatement> {
    @Override
    public void refresh(FederationSchemaMetaData schema, Collection<String> logicDataSourceNames, CreateTableStatement sqlStatement, SchemaBuilderMaterials materials) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        Optional.ofNullable(TableMetaDataBuilder.load(Collections.singletonList(tableName), (SchemaBuilderMaterials)materials).get(tableName)).map(each -> TableMetaDataBuilder.decorateFederationTableMetaData((TableMetaData)each, (Collection)materials.getRules())).ifPresent(schema::update);
    }
}

