/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class EncryptRuleQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional ruleConfig = database.getRuleMetaData().findRuleConfigurations(EncryptRuleConfiguration.class).stream().findAny();
        ruleConfig.ifPresent(optional -> {
            this.data = this.buildData((EncryptRuleConfiguration)optional, (ShowEncryptRulesStatement)sqlStatement).iterator();
        });
    }

    private Collection<Collection<Object>> buildData(EncryptRuleConfiguration ruleConfig, ShowEncryptRulesStatement sqlStatement) {
        return ruleConfig.getTables().stream().filter(each -> Objects.isNull(sqlStatement.getTableName()) || each.getName().equals(sqlStatement.getTableName())).map(each -> this.buildColumnData((EncryptTableRuleConfiguration)each, ruleConfig.getEncryptors())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<Collection<Object>> buildColumnData(EncryptTableRuleConfiguration tableRuleConfig, Map<String, ShardingSphereAlgorithmConfiguration> algorithmMap) {
        LinkedList<Collection<Object>> result = new LinkedList<Collection<Object>>();
        tableRuleConfig.getColumns().forEach(each -> {
            ShardingSphereAlgorithmConfiguration algorithmConfig = (ShardingSphereAlgorithmConfiguration)algorithmMap.get(each.getEncryptorName());
            result.add(Arrays.asList(tableRuleConfig.getName(), each.getLogicColumn(), this.nullToEmptyString(null), each.getCipherColumn(), this.nullToEmptyString(null), this.nullToEmptyString(each.getPlainColumn()), this.nullToEmptyString(null), this.nullToEmptyString(each.getAssistedQueryColumn()), this.nullToEmptyString(null), algorithmConfig.getType(), PropertiesConverter.convert((Properties)algorithmConfig.getProps()), Objects.isNull(tableRuleConfig.getQueryWithCipherColumn()) ? Boolean.TRUE.toString() : tableRuleConfig.getQueryWithCipherColumn().toString()));
        });
        return result;
    }

    private Object nullToEmptyString(Object obj) {
        return null == obj ? "" : obj;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table", "logic_column", "logic_data_type", "cipher_column", "cipher_data_type", "plain_column", "plain_data_type", "assisted_query_column", "assisted_query_data_type", "encryptor_type", "encryptor_props", "query_with_cipher_column");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowEncryptRulesStatement.class.getName();
    }
}

