/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.rule.YamlEncryptTableRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlEncryptRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlEncryptRuleConfiguration, EncryptRuleConfiguration> {
    private final YamlEncryptTableRuleConfigurationSwapper tableSwapper = new YamlEncryptTableRuleConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlEncryptRuleConfiguration swapToYamlConfiguration(EncryptRuleConfiguration data) {
        YamlEncryptRuleConfiguration result = new YamlEncryptRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getName(), this.tableSwapper.swapToYamlConfiguration((EncryptTableRuleConfiguration)each)));
        data.getEncryptors().forEach((key, value) -> result.getEncryptors().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        return result;
    }

    public EncryptRuleConfiguration swapToObject(YamlEncryptRuleConfiguration yamlConfig) {
        return new EncryptRuleConfiguration(this.swapTables(yamlConfig), this.swapEncryptAlgorithm(yamlConfig));
    }

    private Collection<EncryptTableRuleConfiguration> swapTables(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedList<EncryptTableRuleConfiguration> result = new LinkedList<EncryptTableRuleConfiguration>();
        for (Map.Entry<String, YamlEncryptTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            YamlEncryptTableRuleConfiguration yamlEncryptTableRuleConfig = entry.getValue();
            yamlEncryptTableRuleConfig.setName(entry.getKey());
            result.add(this.tableSwapper.swapToObject(yamlEncryptTableRuleConfig));
        }
        return result;
    }

    private Map<String, AlgorithmConfiguration> swapEncryptAlgorithm(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedHashMap<String, AlgorithmConfiguration> result = new LinkedHashMap<String, AlgorithmConfiguration>(yamlConfig.getEncryptors().size(), 1.0f);
        for (Map.Entry<String, YamlAlgorithmConfiguration> entry : yamlConfig.getEncryptors().entrySet()) {
            result.put(entry.getKey(), this.algorithmSwapper.swapToObject(entry.getValue()));
        }
        return result;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "ENCRYPT";
    }

    public int getOrder() {
        return 10;
    }
}

