/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.metadata.nodepath.EncryptRuleNodePathProvider;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.rule.YamlEncryptTableRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.NewYamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.path.RuleNodePath;

public final class NewYamlEncryptRuleConfigurationSwapper
implements NewYamlRuleConfigurationSwapper<EncryptRuleConfiguration> {
    private final YamlEncryptTableRuleConfigurationSwapper tableSwapper = new YamlEncryptTableRuleConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();
    private final RuleNodePath encryptRuleNodePath = new EncryptRuleNodePathProvider().getRuleNodePath();

    public Collection<YamlDataNode> swapToDataNodes(EncryptRuleConfiguration data) {
        LinkedList<YamlDataNode> result = new LinkedList<YamlDataNode>();
        for (Map.Entry entry : data.getEncryptors().entrySet()) {
            result.add(new YamlDataNode(this.encryptRuleNodePath.getNamedItem("encryptors").getPath((String)entry.getKey()), YamlEngine.marshal((Object)this.algorithmSwapper.swapToYamlConfiguration((AlgorithmConfiguration)entry.getValue()))));
        }
        for (EncryptTableRuleConfiguration each : data.getTables()) {
            result.add(new YamlDataNode(this.encryptRuleNodePath.getNamedItem("tables").getPath(each.getName()), YamlEngine.marshal((Object)this.tableSwapper.swapToYamlConfiguration(each))));
        }
        return result;
    }

    public Optional<EncryptRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        List validDataNodes = dataNodes.stream().filter(each -> this.encryptRuleNodePath.getRoot().isValidatedPath(each.getKey())).collect(Collectors.toList());
        if (validDataNodes.isEmpty()) {
            return Optional.empty();
        }
        LinkedList tables = new LinkedList();
        LinkedHashMap encryptors = new LinkedHashMap();
        for (YamlDataNode each2 : validDataNodes) {
            this.encryptRuleNodePath.getNamedItem("tables").getName(each2.getKey()).ifPresent(optional -> tables.add(this.tableSwapper.swapToObject((YamlEncryptTableRuleConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlEncryptTableRuleConfiguration.class))));
            this.encryptRuleNodePath.getNamedItem("encryptors").getName(each2.getKey()).ifPresent(optional -> encryptors.put(optional, this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)each2.getValue(), YamlAlgorithmConfiguration.class))));
        }
        return Optional.of(new EncryptRuleConfiguration(tables, encryptors));
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "ENCRYPT";
    }

    public int getOrder() {
        return 10;
    }
}

