/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule.column.item;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.context.EncryptContext;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;

public final class CipherColumnItem {
    private final String name;
    private final StandardEncryptAlgorithm encryptor;

    public Object encrypt(String databaseName, String schemaName, String tableName, String logicColumnName, Object originalValue) {
        if (null == originalValue) {
            return null;
        }
        EncryptContext context = EncryptContextBuilder.build(databaseName, schemaName, tableName, logicColumnName);
        return this.encryptor.encrypt(originalValue, context);
    }

    public List<Object> encrypt(String databaseName, String schemaName, String tableName, String logicColumnName, List<Object> originalValues) {
        EncryptContext context = EncryptContextBuilder.build(databaseName, schemaName, tableName, logicColumnName);
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            result.add(null == each ? null : this.encryptor.encrypt(each, context));
        }
        return result;
    }

    public Object decrypt(String databaseName, String schemaName, String tableName, String logicColumnName, Object cipherValue) {
        if (null == cipherValue) {
            return null;
        }
        EncryptContext context = EncryptContextBuilder.build(databaseName, schemaName, tableName, logicColumnName);
        return this.encryptor.decrypt(cipherValue, context);
    }

    @Generated
    public CipherColumnItem(String name, StandardEncryptAlgorithm encryptor) {
        this.name = name;
        this.encryptor = encryptor;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public StandardEncryptAlgorithm getEncryptor() {
        return this.encryptor;
    }
}

