/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule.changed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.infra.rule.event.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;

public final class EncryptorChangedProcessor
implements RuleItemConfigurationChangedProcessor<EncryptRuleConfiguration, AlgorithmConfiguration> {
    public AlgorithmConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new YamlAlgorithmConfigurationSwapper().swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlAlgorithmConfiguration.class));
    }

    public EncryptRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(EncryptRule.class).map(optional -> this.getEncryptRuleConfiguration((EncryptRuleConfiguration)optional.getConfiguration())).orElseGet(() -> new EncryptRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    private EncryptRuleConfiguration getEncryptRuleConfiguration(EncryptRuleConfiguration config) {
        return null == config.getTables() ? new EncryptRuleConfiguration(new LinkedList(), config.getEncryptors()) : config;
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, EncryptRuleConfiguration currentRuleConfig, AlgorithmConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getEncryptors().put(((AlterNamedRuleItemEvent)event).getItemName(), toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, EncryptRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getEncryptors().remove(((DropNamedRuleItemEvent)event).getItemName());
    }

    public String getType() {
        return "encrypt.encryptors";
    }
}

