/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.encrypt.assisted.AssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLogicColumnNotFoundException;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.CipherColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class EncryptTable {
    private final String table;
    private final Map<String, EncryptColumn> columns;

    public EncryptTable(EncryptTableRuleConfiguration config, Map<String, StandardEncryptAlgorithm> standardEncryptors, Map<String, AssistedEncryptAlgorithm> assistedEncryptors, Map<String, LikeEncryptAlgorithm> likeEncryptors) {
        this.table = config.getName();
        this.columns = this.createEncryptColumns(config, standardEncryptors, assistedEncryptors, likeEncryptors);
    }

    private Map<String, EncryptColumn> createEncryptColumns(EncryptTableRuleConfiguration config, Map<String, StandardEncryptAlgorithm> standardEncryptors, Map<String, AssistedEncryptAlgorithm> assistedEncryptors, Map<String, LikeEncryptAlgorithm> likeEncryptors) {
        TreeMap<String, EncryptColumn> result = new TreeMap<String, EncryptColumn>(String.CASE_INSENSITIVE_ORDER);
        for (EncryptColumnRuleConfiguration each : config.getColumns()) {
            result.put(each.getName(), this.createEncryptColumn(each, standardEncryptors, assistedEncryptors, likeEncryptors));
        }
        return result;
    }

    private EncryptColumn createEncryptColumn(EncryptColumnRuleConfiguration config, Map<String, StandardEncryptAlgorithm> standardEncryptors, Map<String, AssistedEncryptAlgorithm> assistedEncryptors, Map<String, LikeEncryptAlgorithm> likeEncryptors) {
        EncryptColumn result = new EncryptColumn(config.getName(), new CipherColumnItem(config.getCipher().getName(), standardEncryptors.get(config.getCipher().getEncryptorName())));
        if (config.getAssistedQuery().isPresent()) {
            result.setAssistedQuery(new AssistedQueryColumnItem(((EncryptColumnItemRuleConfiguration)config.getAssistedQuery().get()).getName(), assistedEncryptors.get(((EncryptColumnItemRuleConfiguration)config.getAssistedQuery().get()).getEncryptorName())));
        }
        if (config.getLikeQuery().isPresent()) {
            result.setLikeQuery(new LikeQueryColumnItem(((EncryptColumnItemRuleConfiguration)config.getLikeQuery().get()).getName(), likeEncryptors.get(((EncryptColumnItemRuleConfiguration)config.getLikeQuery().get()).getEncryptorName())));
        }
        return result;
    }

    public Optional<StandardEncryptAlgorithm> findEncryptor(String logicColumnName) {
        return this.columns.containsKey(logicColumnName) ? Optional.of(this.columns.get(logicColumnName).getCipher().getEncryptor()) : Optional.empty();
    }

    public Collection<String> getLogicColumns() {
        return this.columns.keySet();
    }

    public boolean isEncryptColumn(String logicColumnName) {
        return this.columns.containsKey(logicColumnName);
    }

    public EncryptColumn getEncryptColumn(String logicColumnName) {
        ShardingSpherePreconditions.checkState((boolean)this.isEncryptColumn(logicColumnName), () -> new EncryptColumnNotFoundException(this.table, logicColumnName));
        return this.columns.get(logicColumnName);
    }

    public boolean isCipherColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> each.getCipher().getName().equalsIgnoreCase(columnName));
    }

    public String getLogicColumnByCipherColumn(String cipherColumnName) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getCipher().getName().equalsIgnoreCase(cipherColumnName)) continue;
            return entry.getKey();
        }
        throw new EncryptLogicColumnNotFoundException(cipherColumnName);
    }

    public String getLogicColumnByAssistedQueryColumn(String assistQueryColumnName) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getAssistedQuery().isPresent() || !entry.getValue().getAssistedQuery().get().getName().equalsIgnoreCase(assistQueryColumnName)) continue;
            return entry.getKey();
        }
        throw new EncryptLogicColumnNotFoundException(assistQueryColumnName);
    }

    public boolean isAssistedQueryColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> columnName.equalsIgnoreCase(each.getAssistedQuery().map(AssistedQueryColumnItem::getName).orElse(null)));
    }

    public boolean isLikeQueryColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> columnName.equalsIgnoreCase(each.getLikeQuery().map(LikeQueryColumnItem::getName).orElse(null)));
    }

    @Generated
    public String getTable() {
        return this.table;
    }
}

