/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.config.CompatibleEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.encrypt.assisted.AssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.exception.algorithm.MismatchedEncryptAlgorithmTypeException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptTableNotFoundException;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableNamesMapper;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class EncryptRule
implements DatabaseRule,
TableContainedRule {
    private final String databaseName;
    private final RuleConfiguration configuration;
    private final Map<String, EncryptTable> tables = new LinkedHashMap<String, EncryptTable>();
    private final TableNamesMapper tableNamesMapper = new TableNamesMapper();

    public EncryptRule(String databaseName, EncryptRuleConfiguration ruleConfig) {
        this.databaseName = databaseName;
        this.configuration = ruleConfig;
        LinkedHashMap<String, StandardEncryptAlgorithm> standardEncryptors = new LinkedHashMap<String, StandardEncryptAlgorithm>();
        LinkedHashMap<String, AssistedEncryptAlgorithm> assistedEncryptors = new LinkedHashMap<String, AssistedEncryptAlgorithm>();
        LinkedHashMap<String, LikeEncryptAlgorithm> likeEncryptors = new LinkedHashMap<String, LikeEncryptAlgorithm>();
        ruleConfig.getEncryptors().forEach((key, value) -> this.putAllEncryptors((String)key, (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)value.getType(), (Properties)value.getProps()), (Map<String, StandardEncryptAlgorithm>)standardEncryptors, (Map<String, AssistedEncryptAlgorithm>)assistedEncryptors, (Map<String, LikeEncryptAlgorithm>)likeEncryptors));
        for (EncryptTableRuleConfiguration each : ruleConfig.getTables()) {
            each.getColumns().forEach(columnRuleConfig -> this.checkStandardEncryptorType((EncryptColumnRuleConfiguration)columnRuleConfig, (Map<String, StandardEncryptAlgorithm>)standardEncryptors));
            each.getColumns().forEach(columnRuleConfig -> this.checkAssistedQueryEncryptorType((EncryptColumnRuleConfiguration)columnRuleConfig, (Map<String, AssistedEncryptAlgorithm>)assistedEncryptors));
            each.getColumns().forEach(columnRuleConfig -> this.checkLikeQueryEncryptorType((EncryptColumnRuleConfiguration)columnRuleConfig, (Map<String, LikeEncryptAlgorithm>)likeEncryptors));
            this.tables.put(each.getName().toLowerCase(), new EncryptTable(each, standardEncryptors, assistedEncryptors, likeEncryptors));
            this.tableNamesMapper.put(each.getName());
        }
    }

    @Deprecated
    public EncryptRule(String databaseName, CompatibleEncryptRuleConfiguration ruleConfig) {
        this.databaseName = databaseName;
        this.configuration = ruleConfig;
        LinkedHashMap<String, StandardEncryptAlgorithm> standardEncryptors = new LinkedHashMap<String, StandardEncryptAlgorithm>();
        LinkedHashMap<String, AssistedEncryptAlgorithm> assistedEncryptors = new LinkedHashMap<String, AssistedEncryptAlgorithm>();
        LinkedHashMap<String, LikeEncryptAlgorithm> likeEncryptors = new LinkedHashMap<String, LikeEncryptAlgorithm>();
        ruleConfig.getEncryptors().forEach((key, value) -> this.putAllEncryptors((String)key, (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)value.getType(), (Properties)value.getProps()), (Map<String, StandardEncryptAlgorithm>)standardEncryptors, (Map<String, AssistedEncryptAlgorithm>)assistedEncryptors, (Map<String, LikeEncryptAlgorithm>)likeEncryptors));
        for (EncryptTableRuleConfiguration each : ruleConfig.getTables()) {
            each.getColumns().forEach(columnRuleConfig -> this.checkStandardEncryptorType((EncryptColumnRuleConfiguration)columnRuleConfig, (Map<String, StandardEncryptAlgorithm>)standardEncryptors));
            each.getColumns().forEach(columnRuleConfig -> this.checkAssistedQueryEncryptorType((EncryptColumnRuleConfiguration)columnRuleConfig, (Map<String, AssistedEncryptAlgorithm>)assistedEncryptors));
            each.getColumns().forEach(columnRuleConfig -> this.checkLikeQueryEncryptorType((EncryptColumnRuleConfiguration)columnRuleConfig, (Map<String, LikeEncryptAlgorithm>)likeEncryptors));
            this.tables.put(each.getName().toLowerCase(), new EncryptTable(each, standardEncryptors, assistedEncryptors, likeEncryptors));
            this.tableNamesMapper.put(each.getName());
        }
    }

    private void putAllEncryptors(String encryptorName, EncryptAlgorithm algorithm, Map<String, StandardEncryptAlgorithm> standardEncryptors, Map<String, AssistedEncryptAlgorithm> assistedEncryptors, Map<String, LikeEncryptAlgorithm> likeEncryptors) {
        if (algorithm instanceof StandardEncryptAlgorithm) {
            standardEncryptors.put(encryptorName, (StandardEncryptAlgorithm)algorithm);
        }
        if (algorithm instanceof AssistedEncryptAlgorithm) {
            assistedEncryptors.put(encryptorName, (AssistedEncryptAlgorithm)algorithm);
        }
        if (algorithm instanceof LikeEncryptAlgorithm) {
            likeEncryptors.put(encryptorName, (LikeEncryptAlgorithm)algorithm);
        }
    }

    private void checkStandardEncryptorType(EncryptColumnRuleConfiguration columnRuleConfig, Map<String, StandardEncryptAlgorithm> standardEncryptors) {
        ShardingSpherePreconditions.checkState((boolean)standardEncryptors.containsKey(columnRuleConfig.getCipher().getEncryptorName()), () -> new MismatchedEncryptAlgorithmTypeException(this.databaseName, "Cipher", columnRuleConfig.getCipher().getEncryptorName(), StandardEncryptAlgorithm.class.getSimpleName()));
    }

    private void checkAssistedQueryEncryptorType(EncryptColumnRuleConfiguration columnRuleConfig, Map<String, AssistedEncryptAlgorithm> assistedEncryptors) {
        columnRuleConfig.getAssistedQuery().ifPresent(optional -> ShardingSpherePreconditions.checkState((boolean)assistedEncryptors.containsKey(optional.getEncryptorName()), () -> new MismatchedEncryptAlgorithmTypeException(this.databaseName, "Assisted query", optional.getEncryptorName(), AssistedEncryptAlgorithm.class.getSimpleName())));
    }

    private void checkLikeQueryEncryptorType(EncryptColumnRuleConfiguration columnRuleConfig, Map<String, LikeEncryptAlgorithm> likeEncryptors) {
        columnRuleConfig.getLikeQuery().ifPresent(optional -> ShardingSpherePreconditions.checkState((boolean)likeEncryptors.containsKey(optional.getEncryptorName()), () -> new MismatchedEncryptAlgorithmTypeException(this.databaseName, "Like query", optional.getEncryptorName(), LikeEncryptAlgorithm.class.getSimpleName())));
    }

    public Optional<EncryptTable> findEncryptTable(String tableName) {
        return Optional.ofNullable(this.tables.get(tableName.toLowerCase()));
    }

    public EncryptTable getEncryptTable(String tableName) {
        Optional<EncryptTable> encryptTable = this.findEncryptTable(tableName);
        ShardingSpherePreconditions.checkState((boolean)encryptTable.isPresent(), () -> new EncryptTableNotFoundException(tableName));
        return encryptTable.get();
    }

    public TableNamesMapper getLogicTableMapper() {
        return this.tableNamesMapper;
    }

    public TableNamesMapper getActualTableMapper() {
        return new TableNamesMapper();
    }

    public TableNamesMapper getDistributedTableMapper() {
        return new TableNamesMapper();
    }

    public TableNamesMapper getEnhancedTableMapper() {
        return this.getLogicTableMapper();
    }

    @Generated
    public RuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

