/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.util;

import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.ColumnSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptTokenGeneratorUtils {
    public static boolean isAllJoinConditionsUseSameEncryptor(Collection<BinaryOperationExpression> joinConditions, EncryptRule encryptRule) {
        for (BinaryOperationExpression each : joinConditions) {
            EncryptAlgorithm rightColumnEncryptor;
            EncryptAlgorithm leftColumnEncryptor;
            if (!(each.getLeft() instanceof ColumnSegment) || !(each.getRight() instanceof ColumnSegment) || EncryptTokenGeneratorUtils.isSameEncryptor(leftColumnEncryptor = EncryptTokenGeneratorUtils.getColumnEncryptor(((ColumnSegment)each.getLeft()).getColumnBoundedInfo(), encryptRule), rightColumnEncryptor = EncryptTokenGeneratorUtils.getColumnEncryptor(((ColumnSegment)each.getRight()).getColumnBoundedInfo(), encryptRule))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUsingConditionsUseSameEncryptor(Collection<ColumnSegment> usingColumns, EncryptRule encryptRule) {
        for (ColumnSegment each : usingColumns) {
            EncryptAlgorithm rightColumnEncryptor;
            EncryptAlgorithm leftColumnEncryptor = EncryptTokenGeneratorUtils.getColumnEncryptor(each.getColumnBoundedInfo(), encryptRule);
            if (EncryptTokenGeneratorUtils.isSameEncryptor(leftColumnEncryptor, rightColumnEncryptor = EncryptTokenGeneratorUtils.getColumnEncryptor(each.getOtherUsingColumnBoundedInfo(), encryptRule))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameEncryptor(EncryptAlgorithm leftColumnEncryptor, EncryptAlgorithm rightColumnEncryptor) {
        if (null != leftColumnEncryptor && null != rightColumnEncryptor) {
            if (!leftColumnEncryptor.getType().equals(rightColumnEncryptor.getType())) {
                return false;
            }
            return leftColumnEncryptor.equals(rightColumnEncryptor);
        }
        return null == leftColumnEncryptor && null == rightColumnEncryptor;
    }

    private static EncryptAlgorithm getColumnEncryptor(ColumnSegmentBoundedInfo columnBoundedInfo, EncryptRule encryptRule) {
        String tableName = columnBoundedInfo.getOriginalTable().getValue();
        String columnName = columnBoundedInfo.getOriginalColumn().getValue();
        if (!encryptRule.findEncryptTable(tableName).isPresent() || !encryptRule.getEncryptTable(tableName).isEncryptColumn(columnName)) {
            return null;
        }
        EncryptTable encryptTable = encryptRule.getEncryptTable(tableName);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        if (encryptColumn.getAssistedQuery().isPresent()) {
            return encryptColumn.getAssistedQuery().get().getEncryptor();
        }
        return encryptColumn.getCipher().getEncryptor();
    }

    public static boolean isAllInsertSelectColumnsUseSameEncryptor(Collection<ColumnSegment> insertColumns, Collection<Projection> projections, EncryptRule encryptRule) {
        Iterator<ColumnSegment> insertColumnsIterator = insertColumns.iterator();
        Iterator<Projection> projectionIterator = projections.iterator();
        while (insertColumnsIterator.hasNext()) {
            Projection projection;
            ColumnSegmentBoundedInfo columnBoundedInfo;
            EncryptAlgorithm rightColumnEncryptor;
            ColumnSegment columnSegment = insertColumnsIterator.next();
            EncryptAlgorithm leftColumnEncryptor = EncryptTokenGeneratorUtils.getColumnEncryptor(columnSegment.getColumnBoundedInfo(), encryptRule);
            if (EncryptTokenGeneratorUtils.isSameEncryptor(leftColumnEncryptor, rightColumnEncryptor = EncryptTokenGeneratorUtils.getColumnEncryptor(columnBoundedInfo = (projection = projectionIterator.next()) instanceof ColumnProjection ? new ColumnSegmentBoundedInfo(null, null, ((ColumnProjection)projection).getOriginalTable(), ((ColumnProjection)projection).getOriginalColumn()) : new ColumnSegmentBoundedInfo(new IdentifierValue(projection.getColumnLabel())), encryptRule))) continue;
            return false;
        }
        return true;
    }

    @Generated
    private EncryptTokenGeneratorUtils() {
    }
}

