/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptInsertValuesToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptInsertValuesTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
PreviousSQLTokensAware,
EncryptRuleAware,
DatabaseNameAware {
    private List<SQLToken> previousSQLTokens;
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatementContext)sqlStatementContext).getSqlStatement().getValues().isEmpty();
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional<SQLToken> insertValuesToken = this.findPreviousSQLToken(InsertValuesToken.class);
        if (insertValuesToken.isPresent()) {
            this.processPreviousSQLToken(insertStatementContext, (InsertValuesToken)insertValuesToken.get());
            return (InsertValuesToken)insertValuesToken.get();
        }
        return this.generateNewSQLToken(insertStatementContext);
    }

    private Optional<SQLToken> findPreviousSQLToken(Class<?> sqlToken) {
        for (SQLToken each : this.previousSQLTokens) {
            if (!sqlToken.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private void processPreviousSQLToken(InsertStatementContext insertStatementContext, InsertValuesToken insertValuesToken) {
        String tableName = insertStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        int count = 0;
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(insertStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            this.encryptToken((InsertValue)insertValuesToken.getInsertValues().get(count), schemaName, encryptTable, insertStatementContext, each);
            ++count;
        }
    }

    private InsertValuesToken generateNewSQLToken(InsertStatementContext insertStatementContext) {
        String tableName = insertStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        Collection insertValuesSegments = insertStatementContext.getSqlStatement().getValues();
        EncryptInsertValuesToken result = new EncryptInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(insertStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = new InsertValue(each.getValueExpressions());
            this.encryptToken(insertValueToken, schemaName, encryptTable, insertStatementContext, each);
            result.getInsertValues().add(insertValueToken);
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    private void encryptToken(InsertValue insertValueToken, String schemaName, EncryptTable encryptTable, InsertStatementContext insertStatementContext, InsertValueContext insertValueContext) {
        String tableName = encryptTable.getTable();
        Optional<SQLToken> useDefaultInsertColumnsToken = this.findPreviousSQLToken(UseDefaultInsertColumnsToken.class);
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            EncryptColumn encryptColumn = this.encryptRule.getEncryptTable(tableName).getEncryptColumn(columnName);
            int columnIndex = useDefaultInsertColumnsToken.map(optional -> ((UseDefaultInsertColumnsToken)optional).getColumns().indexOf(columnName)).orElseGet(() -> insertStatementContext.getColumnNames().indexOf(columnName));
            Object originalValue = insertValueContext.getLiteralValue(columnIndex).orElse(null);
            ExpressionSegment valueExpression = (ExpressionSegment)insertValueContext.getValueExpressions().get(columnIndex);
            this.setCipherColumn(schemaName, tableName, encryptColumn, insertValueToken, valueExpression, columnIndex, originalValue);
            int indexDelta = 1;
            if (encryptColumn.getAssistedQuery().isPresent()) {
                this.addAssistedQueryColumn(schemaName, tableName, encryptColumn, insertValueToken, valueExpression, columnIndex, indexDelta, originalValue);
                ++indexDelta;
            }
            if (!encryptColumn.getLikeQuery().isPresent()) continue;
            this.addLikeQueryColumn(schemaName, tableName, encryptColumn, insertValueToken, valueExpression, columnIndex, indexDelta, originalValue);
        }
    }

    private void setCipherColumn(String schemaName, String tableName, EncryptColumn encryptColumn, InsertValue insertValueToken, ExpressionSegment valueExpression, int columnIndex, Object originalValue) {
        if (valueExpression instanceof LiteralExpressionSegment) {
            insertValueToken.getValues().set(columnIndex, new LiteralExpressionSegment(valueExpression.getStartIndex(), valueExpression.getStopIndex(), encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), originalValue)));
        }
    }

    private void addAssistedQueryColumn(String schemaName, String tableName, EncryptColumn encryptColumn, InsertValue insertValueToken, ExpressionSegment valueExpression, int columnIndex, int indexDelta, Object originalValue) {
        Optional<AssistedQueryColumnItem> assistedQueryColumnItem = encryptColumn.getAssistedQuery();
        Preconditions.checkState((boolean)assistedQueryColumnItem.isPresent());
        Object derivedValue = assistedQueryColumnItem.get().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), originalValue);
        this.addDerivedColumn(insertValueToken, valueExpression, columnIndex, indexDelta, derivedValue, assistedQueryColumnItem.get().getName());
    }

    private void addLikeQueryColumn(String schemaName, String tableName, EncryptColumn encryptColumn, InsertValue insertValueToken, ExpressionSegment valueExpression, int columnIndex, int indexDelta, Object originalValue) {
        Optional<LikeQueryColumnItem> likeQueryColumnItem = encryptColumn.getLikeQuery();
        Preconditions.checkState((boolean)likeQueryColumnItem.isPresent());
        Object derivedValue = likeQueryColumnItem.get().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), originalValue);
        this.addDerivedColumn(insertValueToken, valueExpression, columnIndex, indexDelta, derivedValue, likeQueryColumnItem.get().getName());
    }

    private void addDerivedColumn(InsertValue insertValueToken, ExpressionSegment valueExpression, int columnIndex, int indexDelta, Object derivedValue, String derivedColumnName) {
        Object derivedExpression = valueExpression instanceof LiteralExpressionSegment ? new DerivedLiteralExpressionSegment(derivedValue) : (valueExpression instanceof ParameterMarkerExpressionSegment ? new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken)) : (valueExpression instanceof ColumnSegment ? this.createColumnSegment((ColumnSegment)valueExpression, derivedColumnName) : valueExpression));
        insertValueToken.getValues().add(columnIndex + indexDelta, derivedExpression);
    }

    private ColumnSegment createColumnSegment(ColumnSegment originalColumn, String columnName) {
        ColumnSegment result = new ColumnSegment(originalColumn.getStartIndex(), originalColumn.getStopIndex(), new IdentifierValue(columnName, originalColumn.getIdentifier().getQuoteCharacter()));
        result.setNestedObjectAttributes(originalColumn.getNestedObjectAttributes());
        originalColumn.getOwner().ifPresent(arg_0 -> ((ColumnSegment)result).setOwner(arg_0));
        result.setColumnBoundedInfo(originalColumn.getColumnBoundedInfo());
        result.setOtherUsingColumnBoundedInfo(originalColumn.getOtherUsingColumnBoundedInfo());
        result.setVariable(originalColumn.isVariable());
        return result;
    }

    private int getParameterIndexCount(InsertValue insertValueToken) {
        int result = 0;
        for (ExpressionSegment each : insertValueToken.getValues()) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        return result;
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

