/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptFunctionAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertOnUpdateTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext>,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).isPresent();
    }

    public Collection<SQLToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        InsertStatement insertStatement = insertStatementContext.getSqlStatement();
        Preconditions.checkState((boolean)InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)insertStatement).isPresent());
        Collection onDuplicateKeyColumnsSegments = ((OnDuplicateKeyColumnsSegment)InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)insertStatement).get()).getColumns();
        if (onDuplicateKeyColumnsSegments.isEmpty()) {
            return Collections.emptyList();
        }
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(insertStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        String tableName = insertStatement.getTable().getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (AssignmentSegment each : onDuplicateKeyColumnsSegments) {
            boolean leftColumnIsEncrypt = encryptTable.isEncryptColumn(((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue());
            if (each.getValue() instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)each.getValue()).getFunctionName())) {
                Optional rightColumnSegment = ((FunctionSegment)each.getValue()).getParameters().stream().findFirst();
                Preconditions.checkState((boolean)rightColumnSegment.isPresent());
                boolean rightColumnIsEncrypt = encryptTable.isEncryptColumn(((ColumnSegment)rightColumnSegment.get()).getIdentifier().getValue());
                if (!leftColumnIsEncrypt && !rightColumnIsEncrypt) continue;
            }
            if (!leftColumnIsEncrypt) continue;
            EncryptColumn encryptColumn = encryptTable.getEncryptColumn(((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue());
            this.generateSQLToken(schemaName, encryptTable, encryptColumn, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String schemaName, EncryptTable encryptTable, EncryptColumn encryptColumn, AssignmentSegment assignmentSegment) {
        if (assignmentSegment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(encryptTable, assignmentSegment));
        }
        if (assignmentSegment.getValue() instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)assignmentSegment.getValue()).getFunctionName())) {
            return Optional.of(this.generateValuesSQLToken(encryptTable, assignmentSegment, (FunctionSegment)assignmentSegment.getValue()));
        }
        if (assignmentSegment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(schemaName, encryptTable.getTable(), encryptColumn, assignmentSegment));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(EncryptTable encryptTable, AssignmentSegment assignmentSegment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(((ColumnSegment)assignmentSegment.getColumns().get(0)).getStartIndex(), assignmentSegment.getStopIndex());
        String columnName = ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue();
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        result.addColumnName(encryptColumn.getCipher().getName());
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.addColumnName(optional.getName()));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.addColumnName(optional.getName()));
        return result;
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment assignmentSegment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(((ColumnSegment)assignmentSegment.getColumns().get(0)).getStartIndex(), assignmentSegment.getStopIndex());
        this.addCipherAssignment(schemaName, tableName, encryptColumn, assignmentSegment, result);
        this.addAssistedQueryAssignment(schemaName, tableName, encryptColumn, assignmentSegment, result);
        this.addLikeAssignment(schemaName, tableName, encryptColumn, assignmentSegment, result);
        return result;
    }

    private EncryptAssignmentToken generateValuesSQLToken(EncryptTable encryptTable, AssignmentSegment assignmentSegment, FunctionSegment functionSegment) {
        ColumnSegment columnSegment = (ColumnSegment)assignmentSegment.getColumns().get(0);
        String column = columnSegment.getIdentifier().getValue();
        Optional valueColumnSegment = functionSegment.getParameters().stream().findFirst();
        Preconditions.checkState((boolean)valueColumnSegment.isPresent());
        String valueColumn = ((ColumnSegment)valueColumnSegment.get()).getIdentifier().getValue();
        EncryptFunctionAssignmentToken result = new EncryptFunctionAssignmentToken(columnSegment.getStartIndex(), assignmentSegment.getStopIndex());
        boolean isEncryptColumn = encryptTable.isEncryptColumn(column);
        boolean isEncryptValueColumn = encryptTable.isEncryptColumn(valueColumn);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(column);
        EncryptColumn encryptValueColumn = encryptTable.getEncryptColumn(column);
        if (isEncryptColumn && isEncryptValueColumn) {
            String cipherColumn = encryptColumn.getCipher().getName();
            String cipherValueColumn = encryptValueColumn.getCipher().getName();
            result.addAssignment(cipherColumn, "VALUES(" + cipherValueColumn + ")");
        } else if (isEncryptColumn != isEncryptValueColumn) {
            throw new UnsupportedEncryptSQLException(String.format("%s=VALUES(%s)", column, valueColumn));
        }
        Optional<AssistedQueryColumnItem> assistedQueryColumn = encryptColumn.getAssistedQuery();
        Optional<AssistedQueryColumnItem> valueAssistedQueryColumn = encryptValueColumn.getAssistedQuery();
        if (assistedQueryColumn.isPresent() && valueAssistedQueryColumn.isPresent()) {
            result.addAssignment(assistedQueryColumn.get().getName(), "VALUES(" + valueAssistedQueryColumn.get().getName() + ")");
        } else if (assistedQueryColumn.isPresent() != valueAssistedQueryColumn.isPresent()) {
            throw new UnsupportedEncryptSQLException(String.format("%s=VALUES(%s)", column, valueColumn));
        }
        Optional<LikeQueryColumnItem> likeQueryColumn = encryptColumn.getLikeQuery();
        Optional<LikeQueryColumnItem> valueLikeQueryColumn = encryptValueColumn.getLikeQuery();
        if (likeQueryColumn.isPresent() && valueLikeQueryColumn.isPresent()) {
            result.addAssignment(likeQueryColumn.get().getName(), "VALUES(" + valueLikeQueryColumn.get().getName() + ")");
        } else if (likeQueryColumn.isPresent() != valueLikeQueryColumn.isPresent()) {
            throw new UnsupportedEncryptSQLException(String.format("%s=VALUES(%s)", column, valueColumn));
        }
        if (result.getAssignment().isEmpty()) {
            throw new UnsupportedEncryptSQLException(String.format("%s=VALUES(%s)", column, valueColumn));
        }
        return result;
    }

    private void addCipherAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Object cipherValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(encryptColumn.getCipher().getName(), cipherValue);
    }

    private void addAssistedQueryAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        encryptColumn.getAssistedQuery().ifPresent(optional -> {
            Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
            Object assistedQueryValue = optional.encrypt(this.databaseName, schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(optional.getName(), assistedQueryValue);
        });
    }

    private void addLikeAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        encryptColumn.getLikeQuery().ifPresent(optional -> {
            Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
            Object likeValue = optional.encrypt(this.databaseName, schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(optional.getName(), likeValue);
        });
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

