/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptProjectionTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
PreviousSQLTokensAware,
EncryptRuleAware,
DatabaseTypeAware {
    private List<SQLToken> previousSQLTokens;
    private EncryptRule encryptRule;
    private DatabaseType databaseType;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getAllTables().isEmpty() || sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        if (sqlStatementContext instanceof SelectStatementContext) {
            this.generateSQLTokens((SelectStatementContext)sqlStatementContext, result);
        } else if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            this.generateSQLTokens(((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext(), result);
        }
        return result;
    }

    private void generateSQLTokens(SelectStatementContext selectStatementContext, Collection<SQLToken> sqlTokens) {
        this.addGenerateSQLTokens(sqlTokens, selectStatementContext);
        for (SelectStatementContext each : selectStatementContext.getSubqueryContexts().values()) {
            this.addGenerateSQLTokens(sqlTokens, each);
        }
    }

    private void addGenerateSQLTokens(Collection<SQLToken> sqlTokens, SelectStatementContext selectStatementContext) {
        for (ProjectionSegment each : selectStatementContext.getSqlStatement().getProjections().getProjections()) {
            ShorthandProjectionSegment shorthandSegment;
            Collection actualColumns;
            SubqueryType subqueryType = selectStatementContext.getSubqueryType();
            if (each instanceof ColumnProjectionSegment) {
                ColumnProjectionSegment columnSegment = (ColumnProjectionSegment)each;
                ColumnProjection columnProjection = this.buildColumnProjection(columnSegment);
                String originalColumnName = columnProjection.getOriginalColumn().getValue();
                Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(columnProjection.getOriginalTable().getValue());
                if (encryptTable.isPresent() && encryptTable.get().isEncryptColumn(originalColumnName) && !selectStatementContext.containsTableSubquery()) {
                    sqlTokens.add((SQLToken)this.generateSQLToken(encryptTable.get().getEncryptColumn(originalColumnName), columnSegment, columnProjection, subqueryType));
                }
            }
            ShardingSpherePreconditions.checkState((!(each instanceof ShorthandProjectionSegment) || !selectStatementContext.containsTableSubquery() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Can not support encrypt shorthand expand with subquery statement"));
            if (!(each instanceof ShorthandProjectionSegment) || (actualColumns = this.getShorthandProjection(shorthandSegment = (ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext()).getActualColumns()).isEmpty()) continue;
            sqlTokens.add((SQLToken)this.generateSQLToken(shorthandSegment, actualColumns, selectStatementContext, subqueryType));
        }
    }

    private ColumnProjection buildColumnProjection(ColumnProjectionSegment segment) {
        IdentifierValue owner = segment.getColumn().getOwner().map(OwnerSegment::getIdentifier).orElse(null);
        ColumnProjection result = new ColumnProjection(owner, segment.getColumn().getIdentifier(), segment.getAliasName().isPresent() ? (IdentifierValue)segment.getAlias().orElse(null) : null, this.databaseType);
        result.setOriginalColumn(segment.getColumn().getColumnBoundedInfo().getOriginalColumn());
        result.setOriginalTable(segment.getColumn().getColumnBoundedInfo().getOriginalTable());
        return result;
    }

    private SubstitutableColumnNameToken generateSQLToken(EncryptColumn encryptColumn, ColumnProjectionSegment columnSegment, ColumnProjection columnProjection, SubqueryType subqueryType) {
        Collection<Projection> projections = this.generateProjections(encryptColumn, columnProjection, subqueryType, false);
        int startIndex = columnSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)columnSegment.getColumn().getOwner().get()).getStopIndex() + 2 : columnSegment.getColumn().getStartIndex();
        return new SubstitutableColumnNameToken(startIndex, columnSegment.getStopIndex(), projections);
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, Collection<Projection> actualColumns, SelectStatementContext selectStatementContext, SubqueryType subqueryType) {
        LinkedList<Projection> projections = new LinkedList<Projection>();
        for (Projection each2 : actualColumns) {
            ColumnProjection columnProjection;
            Optional<EncryptTable> encryptTable;
            if (each2 instanceof ColumnProjection && (encryptTable = this.encryptRule.findEncryptTable((columnProjection = (ColumnProjection)each2).getOriginalTable().getValue())).isPresent() && encryptTable.get().isEncryptColumn(columnProjection.getOriginalColumn().getValue()) && !selectStatementContext.containsTableSubquery()) {
                EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnProjection.getOriginalColumn().getValue());
                projections.addAll(this.generateProjections(encryptColumn, columnProjection, subqueryType, true));
                continue;
            }
            projections.add(each2.getAlias().filter(alias -> !DerivedColumn.isDerivedColumnName((String)alias.getValue())).map(optional -> new ColumnProjection(null, optional, null, this.databaseType)).orElse(each2));
        }
        int startIndex = segment.getOwner().isPresent() ? ((OwnerSegment)segment.getOwner().get()).getStartIndex() : segment.getStartIndex();
        this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(selectStatementContext.getDatabaseType()).getDialectDatabaseMetaData();
        return new SubstitutableColumnNameToken(startIndex, segment.getStopIndex(), projections, dialectDatabaseMetaData.getQuoteCharacter());
    }

    private Collection<Projection> generateProjections(EncryptColumn encryptColumn, ColumnProjection columnProjection, SubqueryType subqueryType, boolean shorthandProjection) {
        if (null == subqueryType || SubqueryType.PROJECTION_SUBQUERY == subqueryType) {
            return Collections.singleton(this.generateProjection(encryptColumn, columnProjection, shorthandProjection));
        }
        if (SubqueryType.TABLE_SUBQUERY == subqueryType || SubqueryType.JOIN_SUBQUERY == subqueryType) {
            return this.generateProjectionsInTableSegmentSubquery(encryptColumn, columnProjection, shorthandProjection, subqueryType);
        }
        if (SubqueryType.PREDICATE_SUBQUERY == subqueryType) {
            return Collections.singleton(this.generateProjectionInPredicateSubquery(encryptColumn, columnProjection, shorthandProjection));
        }
        if (SubqueryType.INSERT_SELECT_SUBQUERY == subqueryType) {
            return this.generateProjectionsInInsertSelectSubquery(encryptColumn, columnProjection, shorthandProjection);
        }
        throw new UnsupportedSQLOperationException("Projections not in simple select, table subquery, join subquery, predicate subquery and insert select subquery are not supported in encrypt feature.");
    }

    private ColumnProjection generateProjection(EncryptColumn encryptColumn, ColumnProjection columnProjection, boolean shorthandProjection) {
        IdentifierValue encryptColumnOwner = shorthandProjection ? (IdentifierValue)columnProjection.getOwner().orElse(null) : null;
        String encryptColumnName = encryptColumn.getCipher().getName();
        return new ColumnProjection(encryptColumnOwner, new IdentifierValue(encryptColumnName, columnProjection.getName().getQuoteCharacter()), columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType);
    }

    private Collection<Projection> generateProjectionsInTableSegmentSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection, boolean shorthandProjection, SubqueryType subqueryType) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        IdentifierValue encryptColumnOwner = shorthandProjection ? (IdentifierValue)columnProjection.getOwner().orElse(null) : null;
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue columnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        IdentifierValue alias = SubqueryType.JOIN_SUBQUERY == subqueryType ? null : columnProjection.getAlias().orElse(columnProjection.getName());
        result.add((Projection)new ColumnProjection(encryptColumnOwner, columnName, alias, this.databaseType));
        IdentifierValue assistedColumOwner = columnProjection.getOwner().orElse(null);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType)));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType)));
        return result;
    }

    private ColumnProjection generateProjectionInPredicateSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection, boolean shorthandProjection) {
        IdentifierValue owner = shorthandProjection ? (IdentifierValue)columnProjection.getOwner().orElse(null) : null;
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        return encryptColumn.getAssistedQuery().map(optional -> new ColumnProjection(owner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType)).orElseGet(() -> new ColumnProjection(owner, new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter), columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType));
    }

    private Collection<Projection> generateProjectionsInInsertSelectSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection, boolean shorthandProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue columnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        LinkedList<Projection> result = new LinkedList<Projection>();
        IdentifierValue encryptColumnOwner = shorthandProjection ? (IdentifierValue)columnProjection.getOwner().orElse(null) : null;
        result.add((Projection)new ColumnProjection(encryptColumnOwner, columnName, null, this.databaseType));
        IdentifierValue assistedColumOwner = columnProjection.getOwner().orElse(null);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType)));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType)));
        return result;
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().map(IdentifierValue::getValue).orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is `%s`", owner.orElse(null)));
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

