/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateEqualRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateFunctionRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateInRightValueToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;

public final class EncryptPredicateRightValueTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
ParametersAware,
EncryptConditionsAware,
EncryptRuleAware,
DatabaseNameAware {
    private List<Object> parameters;
    private Collection<EncryptCondition> encryptConditions;
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (EncryptCondition each : this.encryptConditions) {
            this.encryptRule.findEncryptTable(each.getTableName()).ifPresent(optional -> result.add(this.generateSQLToken(schemaName, (EncryptTable)optional, each)));
        }
        return result;
    }

    private SQLToken generateSQLToken(String schemaName, EncryptTable encryptTable, EncryptCondition encryptCondition) {
        List<Object> originalValues = encryptCondition.getValues(this.parameters);
        int startIndex = encryptCondition.getStartIndex();
        return this.generateSQLToken(schemaName, encryptTable, encryptCondition, originalValues, startIndex);
    }

    private SQLToken generateSQLToken(String schemaName, EncryptTable encryptTable, EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), this.getEncryptedValues(schemaName, encryptTable, encryptCondition, originalValues));
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        if (encryptCondition instanceof EncryptBinaryCondition && ((EncryptBinaryCondition)encryptCondition).getExpressionSegment() instanceof FunctionSegment) {
            return new EncryptPredicateFunctionRightValueToken(startIndex, stopIndex, ((FunctionSegment)((EncryptBinaryCondition)encryptCondition).getExpressionSegment()).getFunctionName(), indexValues, parameterMarkerIndexes);
        }
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptTable encryptTable, EncryptCondition encryptCondition, List<Object> originalValues) {
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(encryptCondition.getColumnName());
        if (encryptCondition instanceof EncryptBinaryCondition && "LIKE".equalsIgnoreCase(((EncryptBinaryCondition)encryptCondition).getOperator())) {
            Optional<LikeQueryColumnItem> likeQueryColumnItem = encryptColumn.getLikeQuery();
            ShardingSpherePreconditions.checkState((boolean)likeQueryColumnItem.isPresent(), () -> new UnsupportedEncryptSQLException("LIKE"));
            return likeQueryColumnItem.get().encrypt(this.databaseName, schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues);
        }
        return encryptColumn.getAssistedQuery().map(optional -> optional.encrypt(this.databaseName, schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues)).orElseGet(() -> encryptColumn.getCipher().encrypt(this.databaseName, schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues));
    }

    private Map<Integer, Object> getPositionValues(Collection<Integer> valuePositions, List<Object> encryptValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (int each : valuePositions) {
            result.put(each, encryptValues.get(each));
        }
        return result;
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    @Generated
    public void setEncryptConditions(Collection<EncryptCondition> encryptConditions) {
        this.encryptConditions = encryptConditions;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

