/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.token.util.EncryptTokenGeneratorUtils;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtils;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptPredicateColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
SchemaMetaDataAware,
EncryptRuleAware,
DatabaseTypeAware {
    private String databaseName;
    private Map<String, ShardingSphereSchema> schemas;
    private EncryptRule encryptRule;
    private DatabaseType databaseType;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        List<ColumnSegment> columnSegments = Collections.emptyList();
        List<WhereSegment> whereSegments = Collections.emptyList();
        Collection<Object> joinConditions = Collections.emptyList();
        if (sqlStatementContext instanceof WhereAvailable) {
            columnSegments = ((WhereAvailable)sqlStatementContext).getColumnSegments();
            whereSegments = ((WhereAvailable)sqlStatementContext).getWhereSegments();
            joinConditions = ((WhereAvailable)sqlStatementContext).getJoinConditions();
        }
        ShardingSpherePreconditions.checkState((boolean)EncryptTokenGeneratorUtils.isAllJoinConditionsUseSameEncryptor(joinConditions, this.encryptRule), () -> new UnsupportedSQLOperationException("Can not use different encryptor in join condition"));
        String defaultSchema = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName);
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.schemas.get(defaultSchema));
        Map columnExpressionTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(columnSegments, schema);
        return this.generateSQLTokens(columnSegments, columnExpressionTableNames, whereSegments);
    }

    private Collection<SQLToken> generateSQLTokens(Collection<ColumnSegment> columnSegments, Map<String, String> columnExpressionTableNames, Collection<WhereSegment> whereSegments) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        for (ColumnSegment each : columnSegments) {
            String tableName = Optional.ofNullable(columnExpressionTableNames.get(each.getExpression())).orElse("");
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(each.getIdentifier().getValue())) continue;
            result.add((SQLToken)this.buildSubstitutableColumnNameToken(encryptTable.get().getEncryptColumn(each.getIdentifier().getValue()), each, whereSegments));
        }
        return result;
    }

    private SubstitutableColumnNameToken buildSubstitutableColumnNameToken(EncryptColumn encryptColumn, ColumnSegment columnSegment, Collection<WhereSegment> whereSegments) {
        int startIndex = columnSegment.getOwner().isPresent() ? ((OwnerSegment)columnSegment.getOwner().get()).getStopIndex() + 2 : columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        if (this.includesLike(whereSegments, columnSegment)) {
            ShardingSpherePreconditions.checkState((boolean)encryptColumn.getLikeQuery().isPresent(), () -> new UnsupportedEncryptSQLException("LIKE"));
            return new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(encryptColumn.getLikeQuery().get().getName(), columnSegment.getIdentifier().getQuoteCharacter()));
        }
        Collection columnProjections = encryptColumn.getAssistedQuery().map(optional -> this.createColumnProjections(optional.getName(), columnSegment.getIdentifier().getQuoteCharacter())).orElseGet(() -> this.createColumnProjections(encryptColumn.getCipher().getName(), columnSegment.getIdentifier().getQuoteCharacter()));
        return new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections);
    }

    private boolean includesLike(Collection<WhereSegment> whereSegments, ColumnSegment targetColumnSegment) {
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtils.getAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate andPredicate : andPredicates) {
                if (!this.isLikeColumnSegment(andPredicate, targetColumnSegment)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLikeColumnSegment(AndPredicate andPredicate, ColumnSegment targetColumnSegment) {
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            if (!(each instanceof BinaryOperationExpression) || !"LIKE".equalsIgnoreCase(((BinaryOperationExpression)each).getOperator()) || !this.isSameColumnSegment(((BinaryOperationExpression)each).getLeft(), targetColumnSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameColumnSegment(ExpressionSegment columnSegment, ColumnSegment targetColumnSegment) {
        return columnSegment instanceof ColumnSegment && columnSegment.getStartIndex() == targetColumnSegment.getStartIndex() && columnSegment.getStopIndex() == targetColumnSegment.getStopIndex();
    }

    private Collection<Projection> createColumnProjections(String columnName, QuoteCharacter quoteCharacter) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, this.databaseType));
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

