/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;

public final class EncryptOrderByItemTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
SchemaMetaDataAware,
EncryptRuleAware {
    private String databaseName;
    private Map<String, ShardingSphereSchema> schemas;
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsOrderByItem(sqlStatementContext);
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        String defaultSchema = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName);
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.schemas.get(defaultSchema));
        for (OrderByItem each : this.getOrderByItems(sqlStatementContext)) {
            if (!(each.getSegment() instanceof ColumnOrderByItemSegment)) continue;
            ColumnSegment columnSegment = ((ColumnOrderByItemSegment)each.getSegment()).getColumn();
            Map columnTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(Collections.singleton(columnSegment), schema);
            result.addAll(this.generateSQLTokensWithColumnSegments(Collections.singleton(columnSegment), columnTableNames));
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokensWithColumnSegments(Collection<ColumnSegment> columnSegments, Map<String, String> columnTableNames) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ColumnSegment each : columnSegments) {
            String tableName = columnTableNames.getOrDefault(each.getExpression(), "");
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
            String columnName = each.getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName) ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("ORDER BY"));
        }
        return result;
    }

    private Collection<OrderByItem> getOrderByItems(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof SelectStatementContext)) {
            return Collections.emptyList();
        }
        LinkedList<OrderByItem> result = new LinkedList<OrderByItem>();
        SelectStatementContext statementContext = (SelectStatementContext)sqlStatementContext;
        if (!statementContext.getOrderByContext().isGenerated()) {
            result.addAll(statementContext.getOrderByContext().getItems());
        }
        for (SelectStatementContext each : statementContext.getSubqueryContexts().values()) {
            result.addAll(this.getOrderByItems((SQLStatementContext)each));
        }
        return result;
    }

    private boolean containsOrderByItem(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof SelectStatementContext)) {
            return false;
        }
        SelectStatementContext statementContext = (SelectStatementContext)sqlStatementContext;
        if (!statementContext.getOrderByContext().getItems().isEmpty() && !statementContext.getOrderByContext().isGenerated()) {
            return true;
        }
        for (SelectStatementContext each : statementContext.getSubqueryContexts().values()) {
            if (!this.containsOrderByItem((SQLStatementContext)each)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

