/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptIndexColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
EncryptRuleAware,
DatabaseTypeAware {
    private EncryptRule encryptRule;
    private DatabaseType databaseType;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof IndexAvailable;
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Preconditions.checkArgument((boolean)(sqlStatementContext instanceof IndexAvailable), (Object)"SQLStatementContext must implementation IndexAvailable interface.");
        if (sqlStatementContext.getTablesContext().getTableNames().isEmpty()) {
            return Collections.emptyList();
        }
        String tableName = (String)sqlStatementContext.getTablesContext().getTableNames().iterator().next();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : ((IndexAvailable)sqlStatementContext).getIndexColumns()) {
            if (!encryptTable.isEncryptColumn(each.getIdentifier().getValue())) continue;
            this.getColumnToken(encryptTable, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SQLToken> getColumnToken(EncryptTable encryptTable, ColumnSegment columnSegment) {
        QuoteCharacter quoteCharacter = columnSegment.getIdentifier().getQuoteCharacter();
        int startIndex = columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        String columnName = columnSegment.getIdentifier().getValue();
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        String queryColumnName = encryptColumn.getAssistedQuery().isPresent() ? encryptColumn.getAssistedQuery().get().getName() : encryptColumn.getCipher().getName();
        return this.getQueryColumnToken(startIndex, stopIndex, queryColumnName, quoteCharacter);
    }

    private Optional<SQLToken> getQueryColumnToken(int startIndex, int stopIndex, String queryColumnName, QuoteCharacter quoteCharacter) {
        Collection<Projection> columnProjections = this.getColumnProjections(queryColumnName, quoteCharacter);
        return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections, quoteCharacter));
    }

    private Collection<Projection> getColumnProjections(String columnName, QuoteCharacter quoteCharacter) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, this.databaseType));
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

