/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptAssignmentTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof UpdateStatementContext || sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).isPresent();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (AssignmentSegment each : this.getSetAssignmentSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            String columnName = ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            this.generateSQLToken(schemaName, encryptTable.getTable(), encryptTable.getEncryptColumn(columnName), each).ifPresent(result::add);
        }
        return result;
    }

    private SetAssignmentSegment getSetAssignmentSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)sqlStatement));
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment segment) {
        if (segment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(encryptColumn, segment));
        }
        if (segment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(schemaName, tableName, encryptColumn, segment));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(EncryptColumn encryptColumn, AssignmentSegment segment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(((ColumnSegment)segment.getColumns().get(0)).getStartIndex(), segment.getStopIndex());
        result.addColumnName(encryptColumn.getCipher().getName());
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.addColumnName(optional.getName()));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.addColumnName(optional.getName()));
        return result;
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment segment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(((ColumnSegment)segment.getColumns().get(0)).getStartIndex(), segment.getStopIndex());
        this.addCipherAssignment(schemaName, tableName, encryptColumn, segment, result);
        this.addAssistedQueryAssignment(schemaName, tableName, encryptColumn, segment, result);
        this.addLikeAssignment(schemaName, tableName, encryptColumn, segment, result);
        return result;
    }

    private void addCipherAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        Object cipherValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(encryptColumn.getCipher().getName(), cipherValue);
    }

    private void addAssistedQueryAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            Object assistedQueryValue = encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, encryptColumn.getName(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(encryptColumn.getAssistedQuery().get().getName(), assistedQueryValue);
        }
    }

    private void addLikeAssignment(String schemaName, String tableName, EncryptColumn encryptColumn, AssignmentSegment segment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)segment.getValue()).getLiterals();
        if (encryptColumn.getLikeQuery().isPresent()) {
            Object assistedQueryValue = encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, ((ColumnSegment)segment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(encryptColumn.getLikeQuery().get().getName(), assistedQueryValue);
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

