/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter
implements ParameterRewriter,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).isPresent();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        InsertStatementContext insertStatementContext = (InsertStatementContext)sqlStatementContext;
        String tableName = insertStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        GroupedParameterBuilder groupedParamBuilder = (GroupedParameterBuilder)paramBuilder;
        OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext = insertStatementContext.getOnDuplicateKeyUpdateValueContext();
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (int index = 0; index < onDuplicateKeyUpdateValueContext.getValueExpressions().size(); ++index) {
            String logicColumnName = onDuplicateKeyUpdateValueContext.getColumn(index).getIdentifier().getValue();
            if (!this.encryptRule.findEncryptTable(tableName).map(optional -> optional.isEncryptColumn(logicColumnName)).orElse(false).booleanValue()) continue;
            Object plainValue = onDuplicateKeyUpdateValueContext.getValue(index);
            if (plainValue instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)plainValue).getFunctionName())) {
                return;
            }
            EncryptColumn encryptColumn = this.encryptRule.getEncryptTable(tableName).getEncryptColumn(logicColumnName);
            Object cipherColumnValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, logicColumnName, plainValue);
            groupedParamBuilder.getGenericParameterBuilder().addReplacedParameters(index, cipherColumnValue);
            Collection<Object> addedParams = this.buildAddedParams(schemaName, tableName, encryptColumn, logicColumnName, plainValue);
            if (addedParams.isEmpty()) continue;
            if (!groupedParamBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().containsKey(index)) {
                groupedParamBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().put(index, new LinkedList());
            }
            ((Collection)groupedParamBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().get(index)).addAll(addedParams);
        }
    }

    private Collection<Object> buildAddedParams(String schemaName, String tableName, EncryptColumn encryptColumn, String logicColumnName, Object plainValue) {
        LinkedList<Object> result = new LinkedList<Object>();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            result.add(encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, logicColumnName, plainValue));
        }
        if (encryptColumn.getLikeQuery().isPresent()) {
            result.add(encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, logicColumnName, plainValue));
        }
        return result;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

