/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptAssignmentParameterRewriter
implements ParameterRewriter,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof UpdateStatementContext) {
            return true;
        }
        if (sqlStatementContext instanceof InsertStatementContext) {
            return InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).isPresent();
        }
        return false;
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        String tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (AssignmentSegment each : this.getSetAssignmentSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            String columnName = ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue();
            if (!(each.getValue() instanceof ParameterMarkerExpressionSegment) || !this.encryptRule.findEncryptTable(tableName).map(optional -> optional.isEncryptColumn(columnName)).orElse(false).booleanValue()) continue;
            EncryptColumn encryptColumn = this.encryptRule.getEncryptTable(tableName).getEncryptColumn(columnName);
            StandardParameterBuilder standardParamBuilder = paramBuilder instanceof StandardParameterBuilder ? (StandardParameterBuilder)paramBuilder : (StandardParameterBuilder)((GroupedParameterBuilder)paramBuilder).getParameterBuilders().get(0);
            this.encryptParameters(standardParamBuilder, schemaName, tableName, encryptColumn, ((ParameterMarkerExpressionSegment)each.getValue()).getParameterMarkerIndex(), params);
        }
    }

    private SetAssignmentSegment getSetAssignmentSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)sqlStatement));
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private void encryptParameters(StandardParameterBuilder paramBuilder, String schemaName, String tableName, EncryptColumn encryptColumn, int parameterMarkerIndex, List<Object> params) {
        String columnName = encryptColumn.getName();
        Object originalValue = params.get(parameterMarkerIndex);
        Object cipherValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, columnName, Collections.singletonList(originalValue)).iterator().next();
        paramBuilder.addReplacedParameters(parameterMarkerIndex, cipherValue);
        LinkedList<Object> addedParams = new LinkedList<Object>();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            addedParams.add(encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, Collections.singletonList(originalValue)).iterator().next());
        }
        if (encryptColumn.getLikeQuery().isPresent()) {
            addedParams.add(encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, Collections.singletonList(originalValue)).iterator().next());
        }
        if (!addedParams.isEmpty()) {
            paramBuilder.addAddedParameters(parameterMarkerIndex, addedParams);
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

