/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptAssignmentParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptInsertValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptPredicateParameterRewriter;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;

public final class EncryptParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final EncryptRule encryptRule;
    private final String databaseName;
    private final Map<String, ShardingSphereSchema> schemas;
    private final SQLStatementContext sqlStatementContext;
    private final Collection<EncryptCondition> encryptConditions;

    public Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        this.addParameterRewriter(result, new EncryptAssignmentParameterRewriter());
        this.addParameterRewriter(result, new EncryptPredicateParameterRewriter());
        this.addParameterRewriter(result, new EncryptInsertValueParameterRewriter());
        this.addParameterRewriter(result, new EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter());
        return result;
    }

    private void addParameterRewriter(Collection<ParameterRewriter> paramRewriters, ParameterRewriter toBeAddedParamRewriter) {
        if (toBeAddedParamRewriter.isNeedRewrite(this.sqlStatementContext)) {
            this.setUpParameterRewriter(toBeAddedParamRewriter);
            paramRewriters.add(toBeAddedParamRewriter);
        }
    }

    private void setUpParameterRewriter(ParameterRewriter toBeAddedParamRewriter) {
        if (toBeAddedParamRewriter instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)toBeAddedParamRewriter).setSchemas(this.schemas);
        }
        if (toBeAddedParamRewriter instanceof EncryptRuleAware) {
            ((EncryptRuleAware)toBeAddedParamRewriter).setEncryptRule(this.encryptRule);
        }
        if (toBeAddedParamRewriter instanceof EncryptConditionsAware) {
            ((EncryptConditionsAware)toBeAddedParamRewriter).setEncryptConditions(this.encryptConditions);
        }
        if (toBeAddedParamRewriter instanceof DatabaseNameAware) {
            ((DatabaseNameAware)toBeAddedParamRewriter).setDatabaseName(this.databaseName);
        }
        if (toBeAddedParamRewriter instanceof DatabaseTypeAware) {
            ((DatabaseTypeAware)toBeAddedParamRewriter).setDatabaseType(this.sqlStatementContext.getDatabaseType());
        }
    }

    @Generated
    public EncryptParameterRewriterBuilder(EncryptRule encryptRule, String databaseName, Map<String, ShardingSphereSchema> schemas, SQLStatementContext sqlStatementContext, Collection<EncryptCondition> encryptConditions) {
        this.encryptRule = encryptRule;
        this.databaseName = databaseName;
        this.schemas = schemas;
        this.sqlStatementContext = sqlStatementContext;
        this.encryptConditions = encryptConditions;
    }
}

