/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata.reviser.index;

import java.util.LinkedHashSet;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.index.IndexReviser;

public final class EncryptIndexReviser
implements IndexReviser<EncryptRule> {
    private final EncryptTable encryptTable;

    public Optional<IndexMetaData> revise(String tableName, IndexMetaData originalMetaData, EncryptRule rule) {
        if (originalMetaData.getColumns().isEmpty()) {
            return Optional.empty();
        }
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (String each : originalMetaData.getColumns()) {
            if (this.encryptTable.isCipherColumn(each)) {
                columns.add(this.encryptTable.getLogicColumnByCipherColumn(each));
                continue;
            }
            if (this.encryptTable.isAssistedQueryColumn(each)) {
                columns.add(this.encryptTable.getLogicColumnByAssistedQueryColumn(each));
                continue;
            }
            columns.add(each);
        }
        IndexMetaData result = new IndexMetaData(originalMetaData.getName());
        result.getColumns().addAll(columns);
        result.setUnique(originalMetaData.isUnique());
        return Optional.of(result);
    }

    @Generated
    public EncryptIndexReviser(EncryptTable encryptTable) {
        this.encryptTable = encryptTable;
    }
}

