/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class EncryptMergedResult
implements MergedResult {
    private final ShardingSphereDatabase database;
    private final EncryptRule encryptRule;
    private final SelectStatementContext selectStatementContext;
    private final MergedResult mergedResult;

    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Optional columnProjection = this.selectStatementContext.findColumnProjection(columnIndex);
        if (!columnProjection.isPresent()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        String originalTableName = ((ColumnProjection)columnProjection.get()).getOriginalTable().getValue();
        String originalColumnName = ((ColumnProjection)columnProjection.get()).getOriginalColumn().getValue();
        if (!this.encryptRule.findEncryptTable(originalTableName).map(optional -> optional.isEncryptColumn(originalColumnName)).orElse(false).booleanValue()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Object cipherValue = this.mergedResult.getValue(columnIndex, Object.class);
        EncryptColumn encryptColumn = this.encryptRule.getEncryptTable(originalTableName).getEncryptColumn(originalColumnName);
        String schemaName = this.selectStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(this.selectStatementContext.getDatabaseType()).getDefaultSchemaName(this.database.getName()));
        return encryptColumn.getCipher().decrypt(this.database.getName(), schemaName, originalTableName, originalColumnName, cipherValue);
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        return this.mergedResult.getCalendarValue(columnIndex, type, calendar);
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        return this.mergedResult.getInputStream(columnIndex, type);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.mergedResult.getCharacterStream(columnIndex);
    }

    public boolean wasNull() throws SQLException {
        return this.mergedResult.wasNull();
    }

    @Generated
    public EncryptMergedResult(ShardingSphereDatabase database, EncryptRule encryptRule, SelectStatementContext selectStatementContext, MergedResult mergedResult) {
        this.database = database;
        this.encryptRule = encryptRule;
        this.selectStatementContext = selectStatementContext;
        this.mergedResult = mergedResult;
    }
}

