/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import com.google.common.base.Splitter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public abstract class EncryptShowCreateTableMergedResult
implements MergedResult {
    private static final String COMMA = ",";
    private static final int CREATE_TABLE_DEFINITION_INDEX = 2;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;
    private final String tableName;
    private final EncryptRule encryptRule;

    protected EncryptShowCreateTableMergedResult(SQLStatementContext sqlStatementContext, EncryptRule encryptRule) {
        ShardingSpherePreconditions.checkState((sqlStatementContext instanceof TableAvailable && 1 == ((TableAvailable)sqlStatementContext).getAllTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW CREATE TABLE FOR MULTI TABLE"));
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDialectDatabaseMetaData();
        this.tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        this.encryptRule = encryptRule;
    }

    public final boolean next() throws SQLException {
        return this.nextValue();
    }

    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (2 == columnIndex) {
            String result = this.getOriginalValue(2, type).toString();
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(this.tableName);
            if (!encryptTable.isPresent()) {
                return result;
            }
            StringBuilder builder = new StringBuilder(result.substring(0, result.indexOf(40) + 1));
            List columnDefinitions = Splitter.on((String)COMMA).splitToList((CharSequence)result.substring(result.indexOf(40) + 1, result.lastIndexOf(41)));
            for (String each : columnDefinitions) {
                this.findLogicColumnDefinition(each, encryptTable.get()).ifPresent(optional -> builder.append((String)optional).append(COMMA));
            }
            builder.deleteCharAt(builder.length() - 1).append(result.substring(result.lastIndexOf(41)));
            return builder.toString();
        }
        return this.getOriginalValue(columnIndex, type);
    }

    private Optional<String> findLogicColumnDefinition(String columnDefinition, EncryptTable encryptTable) {
        String columnName = this.dialectDatabaseMetaData.getQuoteCharacter().unwrap(columnDefinition.trim().split("\\s+")[0]);
        if (encryptTable.isCipherColumn(columnName)) {
            return Optional.of(columnDefinition.replace(columnName, encryptTable.getLogicColumnByCipherColumn(columnName)));
        }
        if (this.isDerivedColumn(encryptTable, columnName)) {
            return Optional.empty();
        }
        return Optional.of(columnDefinition);
    }

    private boolean isDerivedColumn(EncryptTable encryptTable, String columnName) {
        return encryptTable.isAssistedQueryColumn(columnName) || encryptTable.isLikeQueryColumn(columnName);
    }

    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    protected abstract boolean nextValue() throws SQLException;

    protected abstract Object getOriginalValue(int var1, Class<?> var2) throws SQLException;
}

