/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Calendar;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public abstract class EncryptShowColumnsMergedResult
implements MergedResult {
    private static final int COLUMN_FIELD_INDEX = 1;
    private final String tableName;
    private final EncryptRule encryptRule;

    protected EncryptShowColumnsMergedResult(SQLStatementContext sqlStatementContext, EncryptRule encryptRule) {
        ShardingSpherePreconditions.checkState((sqlStatementContext instanceof TableAvailable && 1 == ((TableAvailable)sqlStatementContext).getAllTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW COLUMNS FOR MULTI TABLE"));
        this.tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        this.encryptRule = encryptRule;
    }

    public final boolean next() throws SQLException {
        boolean hasNext = this.nextValue();
        Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(this.tableName);
        if (hasNext && !encryptTable.isPresent()) {
            return true;
        }
        if (!hasNext) {
            return false;
        }
        String columnName = this.getOriginalValue(1, String.class).toString();
        while (this.isDerivedColumn(encryptTable.get(), columnName)) {
            hasNext = this.nextValue();
            if (!hasNext) {
                return false;
            }
            columnName = this.getOriginalValue(1, String.class).toString();
        }
        return true;
    }

    private boolean isDerivedColumn(EncryptTable encryptTable, String columnName) {
        return encryptTable.isAssistedQueryColumn(columnName) || encryptTable.isLikeQueryColumn(columnName);
    }

    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (1 == columnIndex) {
            String columnName = this.getOriginalValue(1, type).toString();
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(this.tableName);
            if (!encryptTable.isPresent()) {
                return columnName;
            }
            Optional<String> logicColumn = encryptTable.get().isCipherColumn(columnName) ? Optional.of(encryptTable.get().getLogicColumnByCipherColumn(columnName)) : Optional.empty();
            return logicColumn.orElse(columnName);
        }
        return this.getOriginalValue(columnIndex, type);
    }

    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    protected abstract boolean nextValue() throws SQLException;

    protected abstract Object getOriginalValue(int var1, Class<?> var2) throws SQLException;
}

