/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal;

import org.apache.shardingsphere.encrypt.merge.dal.show.DecoratedEncryptShowColumnsMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.show.DecoratedEncryptShowCreateTableMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.show.MergedEncryptShowColumnsMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.show.MergedEncryptShowCreateTableMergedResult;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateTableStatement;

public final class EncryptDALResultDecorator
implements ResultDecorator<EncryptRule> {
    public MergedResult decorate(QueryResult queryResult, SQLStatementContext sqlStatementContext, EncryptRule rule) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof MySQLExplainStatement || sqlStatement instanceof MySQLShowColumnsStatement) {
            return new MergedEncryptShowColumnsMergedResult(queryResult, sqlStatementContext, rule);
        }
        if (sqlStatement instanceof MySQLShowCreateTableStatement) {
            return new MergedEncryptShowCreateTableMergedResult(queryResult, sqlStatementContext, rule);
        }
        return new TransparentMergedResult(queryResult);
    }

    public MergedResult decorate(MergedResult mergedResult, SQLStatementContext sqlStatementContext, EncryptRule rule) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof MySQLExplainStatement || sqlStatement instanceof MySQLShowColumnsStatement) {
            return new DecoratedEncryptShowColumnsMergedResult(mergedResult, sqlStatementContext, rule);
        }
        if (sqlStatement instanceof MySQLShowCreateTableStatement) {
            return new DecoratedEncryptShowCreateTableMergedResult(mergedResult, sqlStatementContext, rule);
        }
        return mergedResult;
    }
}

