/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptAssistedQueryColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptCipherColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLikeQueryColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingEncryptorException;
import org.apache.shardingsphere.encrypt.exception.metadata.UnregisteredEncryptorException;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class EncryptRuleConfigurationChecker
implements RuleConfigurationChecker<EncryptRuleConfiguration> {
    public void check(String databaseName, EncryptRuleConfiguration config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkTableConfiguration(databaseName, config.getTables(), config.getEncryptors());
    }

    private void checkTableConfiguration(String databaseName, Collection<EncryptTableRuleConfiguration> tableRuleConfigs, Map<String, AlgorithmConfiguration> encryptors) {
        for (EncryptTableRuleConfiguration each : tableRuleConfigs) {
            this.checkColumnConfiguration(databaseName, each, encryptors);
        }
    }

    private void checkColumnConfiguration(String databaseName, EncryptTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        for (EncryptColumnRuleConfiguration each : tableRuleConfig.getColumns()) {
            this.checkCipherColumnConfiguration(databaseName, tableRuleConfig.getName(), each.getName(), each.getCipher(), encryptors);
            each.getAssistedQuery().ifPresent(optional -> this.checkAssistColumnConfiguration(databaseName, tableRuleConfig.getName(), each.getName(), (EncryptColumnItemRuleConfiguration)optional, encryptors));
            each.getLikeQuery().ifPresent(optional -> this.checkLikeColumnConfiguration(databaseName, tableRuleConfig.getName(), each.getName(), (EncryptColumnItemRuleConfiguration)optional, encryptors));
        }
    }

    private void checkCipherColumnConfiguration(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration cipherColumnConfig, Map<String, AlgorithmConfiguration> encryptors) {
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)cipherColumnConfig.getName()) ? 1 : 0) != 0, () -> new EncryptCipherColumnNotFoundException(logicColumnName, databaseName));
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)cipherColumnConfig.getEncryptorName()) ? 1 : 0) != 0, () -> new MissingEncryptorException(tableName, logicColumnName, "STANDARD"));
        ShardingSpherePreconditions.checkState((boolean)encryptors.containsKey(cipherColumnConfig.getEncryptorName()), () -> new UnregisteredEncryptorException(databaseName, cipherColumnConfig.getEncryptorName()));
    }

    private void checkAssistColumnConfiguration(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration assistedQueryColumnConfig, Map<String, AlgorithmConfiguration> encryptors) {
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)assistedQueryColumnConfig.getName()) ? 1 : 0) != 0, () -> new EncryptAssistedQueryColumnNotFoundException(logicColumnName, databaseName));
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)assistedQueryColumnConfig.getEncryptorName()) ? 1 : 0) != 0, () -> new MissingEncryptorException(tableName, logicColumnName, "ASSIST_QUERY"));
        ShardingSpherePreconditions.checkState((boolean)encryptors.containsKey(assistedQueryColumnConfig.getEncryptorName()), () -> new UnregisteredEncryptorException(databaseName, assistedQueryColumnConfig.getEncryptorName()));
    }

    private void checkLikeColumnConfiguration(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration likeQueryColumnConfig, Map<String, AlgorithmConfiguration> encryptors) {
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)likeQueryColumnConfig.getName()) ? 1 : 0) != 0, () -> new EncryptLikeQueryColumnNotFoundException(logicColumnName, databaseName));
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)likeQueryColumnConfig.getEncryptorName()) ? 1 : 0) != 0, () -> new MissingEncryptorException(tableName, logicColumnName, "LIKE_QUERY"));
        ShardingSpherePreconditions.checkState((boolean)encryptors.containsKey(likeQueryColumnConfig.getEncryptorName()), () -> new UnregisteredEncryptorException(databaseName, likeQueryColumnConfig.getEncryptorName()));
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }
}

