/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm.standard;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.encrypt.api.context.EncryptContext;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.exception.algorithm.EncryptAlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class AESEncryptAlgorithm
implements StandardEncryptAlgorithm {
    private static final String AES_KEY = "aes-key-value";
    private static final String DIGEST_ALGORITHM_NAME = "digest-algorithm-name";
    private byte[] secretKey;

    public void init(Properties props) {
        this.secretKey = this.createSecretKey(props);
    }

    private byte[] createSecretKey(Properties props) {
        String aesKey = props.getProperty(AES_KEY);
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)aesKey) ? 1 : 0) != 0, () -> new EncryptAlgorithmInitializationException(this.getType(), String.format("%s can not be null or empty", AES_KEY)));
        String digestAlgorithm = props.getProperty(DIGEST_ALGORITHM_NAME, "SHA-1");
        return Arrays.copyOf(DigestUtils.getDigest((String)digestAlgorithm.toUpperCase()).digest(aesKey.getBytes(StandardCharsets.UTF_8)), 16);
    }

    public String encrypt(Object plainValue, EncryptContext encryptContext) {
        if (null == plainValue) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(String.valueOf(plainValue).getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(result);
    }

    public Object decrypt(Object cipherValue, EncryptContext encryptContext) {
        if (null == cipherValue) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(Base64.getDecoder().decode(cipherValue.toString().trim()));
        return new String(result, StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int decryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.secretKey, this.getType()));
        return result;
    }

    public String getType() {
        return "AES";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AESEncryptAlgorithm)) {
            return false;
        }
        AESEncryptAlgorithm other = (AESEncryptAlgorithm)o;
        return Arrays.equals(this.secretKey, other.secretKey);
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.secretKey);
        return result;
    }
}

