/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;

public final class DropDatabaseDiscoveryRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropDatabaseDiscoveryRuleStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "Database discovery";

    public void checkSQLStatement(ShardingSphereDatabase database, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, sqlStatement, currentRuleConfig);
        this.checkIsInUse(databaseName, sqlStatement, database);
    }

    private void checkCurrentRuleConfiguration(String databaseName, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException(RULE_TYPE, databaseName));
        this.checkIsExist(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkIsExist(String databaseName, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getRuleNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedRuleNames.isEmpty(), () -> new RequiredRuleMissedException(RULE_TYPE, databaseName));
    }

    private void checkIsInUse(String databaseName, DropDatabaseDiscoveryRuleStatement sqlStatement, ShardingSphereDatabase database) throws DistSQLException {
        Optional<ExportableRule> exportableRule = database.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Collections.singletonList("dynamic_readwrite_splitting_rules"))).findFirst();
        ArrayList rulesInUse = new ArrayList();
        exportableRule.ifPresent(op -> {
            Map readwriteRuleMap = op.export("dynamic_readwrite_splitting_rules").map(each -> (Map)each).orElse(Collections.emptyMap());
            readwriteRuleMap.values().stream().map(each -> (String)each.get("auto_aware_data_source_name")).forEach(rulesInUse::add);
        });
        Collection invalid = sqlStatement.getRuleNames().stream().filter(rulesInUse::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), () -> new RuleInUsedException(RULE_TYPE, databaseName, invalid));
    }

    public boolean updateCurrentRuleConfiguration(DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getRuleNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return false;
    }

    private void dropRule(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<DatabaseDiscoveryDataSourceRuleConfiguration> dataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(each -> each.getGroupName().equals(ruleName)).findAny();
        dataSourceRuleConfig.ifPresent(optional -> currentRuleConfig.getDataSources().remove(dataSourceRuleConfig.get()));
    }

    public boolean hasAnyOneToBeDropped(DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        return this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && !this.getIdenticalData(currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName).collect(Collectors.toSet()), sqlStatement.getRuleNames()).isEmpty();
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return DropDatabaseDiscoveryRuleStatement.class.getName();
    }
}

