/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class DropDatabaseDiscoveryHeartbeatStatementUpdater
implements RuleDefinitionDropUpdater<DropDatabaseDiscoveryHeartbeatStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "Database discovery";

    public void checkSQLStatement(ShardingSphereDatabase database, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, sqlStatement, currentRuleConfig);
        this.checkIsInUse(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException(RULE_TYPE, databaseName));
        this.checkIsExist(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkIsExist(String databaseName, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set currentRuleNames = currentRuleConfig.getDiscoveryHeartbeats().keySet();
        Collection notExistedRuleNames = sqlStatement.getHeartbeatNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedRuleNames.isEmpty(), () -> new RequiredRuleMissedException(RULE_TYPE, databaseName, notExistedRuleNames));
    }

    private void checkIsInUse(String databaseName, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection heartbeatInUse = currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getDiscoveryHeartbeatName).collect(Collectors.toSet());
        Collection invalid = sqlStatement.getHeartbeatNames().stream().filter(heartbeatInUse::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), () -> new RuleInUsedException(RULE_TYPE, databaseName, invalid));
    }

    public boolean updateCurrentRuleConfiguration(DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getHeartbeatNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return false;
    }

    private void dropRule(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String heartbeatName) {
        currentRuleConfig.getDiscoveryHeartbeats().remove(heartbeatName);
    }

    public boolean hasAnyOneToBeDropped(DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        return this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && !this.getIdenticalData(currentRuleConfig.getDiscoveryHeartbeats().keySet(), sqlStatement.getHeartbeatNames()).isEmpty();
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return DropDatabaseDiscoveryHeartbeatStatement.class.getName();
    }
}

