/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryProviderAlgorithmSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.factory.DatabaseDiscoveryProviderAlgorithmFactory;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class CreateDatabaseDiscoveryTypeStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDatabaseDiscoveryTypeStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereDatabase database, CreateDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkDuplicateDiscoveryType(databaseName, sqlStatement, currentRuleConfig);
        this.checkInvalidDiscoverType(sqlStatement);
    }

    private void checkDuplicateDiscoveryType(String databaseName, CreateDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig) {
            return;
        }
        Set existRuleNames = currentRuleConfig.getDiscoveryTypes().keySet();
        Collection duplicateRuleNames = sqlStatement.getProviders().stream().map(DatabaseDiscoveryProviderAlgorithmSegment::getDiscoveryProviderName).filter(existRuleNames::contains).collect(Collectors.toSet());
        duplicateRuleNames.addAll(this.getToBeCreatedDuplicateRuleNames(sqlStatement));
        DistSQLException.predictionThrow((boolean)duplicateRuleNames.isEmpty(), () -> new DuplicateRuleException(RULE_TYPE, databaseName, duplicateRuleNames));
    }

    private Collection<String> getToBeCreatedDuplicateRuleNames(CreateDatabaseDiscoveryTypeStatement sqlStatement) {
        return sqlStatement.getProviders().stream().collect(Collectors.toMap(DatabaseDiscoveryProviderAlgorithmSegment::getDiscoveryProviderName, each -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void checkInvalidDiscoverType(CreateDatabaseDiscoveryTypeStatement sqlStatement) throws DistSQLException {
        Collection invalidType = sqlStatement.getProviders().stream().map(each -> each.getAlgorithm().getName()).distinct().filter(each -> !DatabaseDiscoveryProviderAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidType.isEmpty(), () -> new InvalidAlgorithmConfigurationException(RULE_TYPE, invalidType));
    }

    public RuleConfiguration buildToBeCreatedRuleConfiguration(CreateDatabaseDiscoveryTypeStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryProviderAlgorithm(sqlStatement.getProviders());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryTypes().putAll(toBeCreatedRuleConfig.getDiscoveryTypes());
        }
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return CreateDatabaseDiscoveryTypeStatement.class.getName();
    }
}

