/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryProviderAlgorithmSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.factory.DatabaseDiscoveryProviderAlgorithmFactory;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class AlterDatabaseDiscoveryTypeStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDatabaseDiscoveryTypeStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereDatabase database, AlterDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkDuplicateDiscoveryType(databaseName, sqlStatement);
        this.checkNotExistDiscoveryType(databaseName, sqlStatement, currentRuleConfig);
        this.checkInvalidDiscoverType(sqlStatement);
    }

    private void checkNotExistDiscoveryType(String databaseName, AlterDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set existTypes = currentRuleConfig.getDiscoveryTypes().keySet();
        Collection notExistTypes = sqlStatement.getProviders().stream().map(DatabaseDiscoveryProviderAlgorithmSegment::getDiscoveryProviderName).filter(each -> !existTypes.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistTypes.isEmpty(), () -> new RequiredRuleMissedException(RULE_TYPE, databaseName));
    }

    private void checkCurrentRuleConfiguration(String databaseName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException(RULE_TYPE, databaseName));
    }

    private void checkDuplicateDiscoveryType(String databaseName, AlterDatabaseDiscoveryTypeStatement sqlStatement) throws DistSQLException {
        Collection<String> duplicateTypeNames = this.getToBeAlteredDuplicateTypeNames(sqlStatement);
        DistSQLException.predictionThrow((boolean)duplicateTypeNames.isEmpty(), () -> new DuplicateRuleException(RULE_TYPE, databaseName, duplicateTypeNames));
    }

    private Collection<String> getToBeAlteredDuplicateTypeNames(AlterDatabaseDiscoveryTypeStatement sqlStatement) {
        return sqlStatement.getProviders().stream().collect(Collectors.toMap(DatabaseDiscoveryProviderAlgorithmSegment::getDiscoveryProviderName, each -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void checkInvalidDiscoverType(AlterDatabaseDiscoveryTypeStatement sqlStatement) throws DistSQLException {
        Collection invalidType = sqlStatement.getProviders().stream().map(each -> each.getAlgorithm().getName()).distinct().filter(each -> !DatabaseDiscoveryProviderAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidType.isEmpty(), () -> new InvalidAlgorithmConfigurationException(RULE_TYPE, invalidType));
    }

    public RuleConfiguration buildToBeAlteredRuleConfiguration(AlterDatabaseDiscoveryTypeStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryProviderAlgorithm(sqlStatement.getProviders());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeAlteredRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryTypes().putAll(toBeAlteredRuleConfig.getDiscoveryTypes());
        }
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return AlterDatabaseDiscoveryTypeStatement.class.getName();
    }
}

