/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryHeartbeatSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class AlterDatabaseDiscoveryHeartbeatStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDatabaseDiscoveryHeartbeatStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public DatabaseDiscoveryRuleConfiguration buildToBeAlteredRuleConfiguration(AlterDatabaseDiscoveryHeartbeatStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryHeartbeat(sqlStatement.getHeartbeats());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryHeartbeats().putAll(toBeCreatedRuleConfig.getDiscoveryHeartbeats());
        }
    }

    public void checkSQLStatement(ShardingSphereDatabase database, AlterDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentConfiguration(databaseName, currentRuleConfig);
        this.checkDuplicateHeartbeat(databaseName, sqlStatement);
        this.checkNotExistHeartbeat(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentConfiguration(String databaseName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((currentRuleConfig != null ? 1 : 0) != 0, () -> new RequiredRuleMissedException(RULE_TYPE, databaseName));
    }

    private void checkNotExistHeartbeat(String databaseName, AlterDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set currentHeartbeats = currentRuleConfig.getDiscoveryHeartbeats().keySet();
        Collection notExistHeartbeats = sqlStatement.getHeartbeats().stream().map(DatabaseDiscoveryHeartbeatSegment::getHeartbeatName).filter(each -> !currentHeartbeats.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistHeartbeats.isEmpty(), () -> new RequiredRuleMissedException(RULE_TYPE, databaseName, notExistHeartbeats));
    }

    private void checkDuplicateHeartbeat(String databaseName, AlterDatabaseDiscoveryHeartbeatStatement sqlStatement) throws DistSQLException {
        Collection<String> duplicateRuleNames = this.getToBeCreatedDuplicateRuleNames(sqlStatement);
        DistSQLException.predictionThrow((boolean)duplicateRuleNames.isEmpty(), () -> new DuplicateRuleException(RULE_TYPE, databaseName, duplicateRuleNames));
    }

    private Collection<String> getToBeCreatedDuplicateRuleNames(AlterDatabaseDiscoveryHeartbeatStatement sqlStatement) {
        return sqlStatement.getHeartbeats().stream().collect(Collectors.toMap(DatabaseDiscoveryHeartbeatSegment::getHeartbeatName, each -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return AlterDatabaseDiscoveryHeartbeatStatement.class.getName();
    }
}

