/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.algorithm.DatabaseDiscoveryEngine;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.factory.DatabaseDiscoveryProviderAlgorithmFactory;
import org.apache.shardingsphere.dbdiscovery.heartbeat.HeartbeatJob;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryDataSourceRule;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.datasource.strategy.DynamicDataSourceStrategyFactory;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.schedule.core.api.CronJob;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContext;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContextFactory;

public final class DatabaseDiscoveryRule
implements SchemaRule,
DataSourceContainedRule,
StatusContainedRule,
ExportableRule,
InstanceAwareRule {
    private final Map<String, DatabaseDiscoveryProviderAlgorithm> discoveryTypes;
    private final Map<String, DatabaseDiscoveryDataSourceRule> dataSourceRules;
    private final String databaseName;
    private final Map<String, DataSource> dataSourceMap;

    public DatabaseDiscoveryRule(String databaseName, Map<String, DataSource> dataSourceMap, DatabaseDiscoveryRuleConfiguration config) {
        this(databaseName, dataSourceMap, config.getDataSources(), config.getDiscoveryHeartbeats(), DatabaseDiscoveryRule.getDiscoveryProviderAlgorithms(config.getDiscoveryTypes()));
    }

    public DatabaseDiscoveryRule(String databaseName, Map<String, DataSource> dataSourceMap, AlgorithmProvidedDatabaseDiscoveryRuleConfiguration config) {
        this(databaseName, dataSourceMap, config.getDataSources(), config.getDiscoveryHeartbeats(), config.getDiscoveryTypes());
    }

    private DatabaseDiscoveryRule(String databaseName, Map<String, DataSource> dataSourceMap, Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSourceRuleConfigs, Map<String, DatabaseDiscoveryHeartBeatConfiguration> heartBeatConfig, Map<String, DatabaseDiscoveryProviderAlgorithm> discoveryTypes) {
        this.discoveryTypes = discoveryTypes;
        this.databaseName = databaseName;
        this.dataSourceMap = dataSourceMap;
        this.dataSourceRules = this.getDataSourceRules(dataSourceRuleConfigs, heartBeatConfig);
        this.findMasterSlaveRelation(databaseName, dataSourceMap);
        this.initAware();
    }

    private static Map<String, DatabaseDiscoveryProviderAlgorithm> getDiscoveryProviderAlgorithms(Map<String, ShardingSphereAlgorithmConfiguration> discoveryTypesConfig) {
        LinkedHashMap<String, DatabaseDiscoveryProviderAlgorithm> result = new LinkedHashMap<String, DatabaseDiscoveryProviderAlgorithm>(discoveryTypesConfig.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry : discoveryTypesConfig.entrySet()) {
            result.put(entry.getKey(), DatabaseDiscoveryProviderAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)entry.getValue()));
        }
        return result;
    }

    private Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules(Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources, Map<String, DatabaseDiscoveryHeartBeatConfiguration> heartbeatConfig) {
        HashMap<String, DatabaseDiscoveryDataSourceRule> result = new HashMap<String, DatabaseDiscoveryDataSourceRule>(dataSources.size(), 1.0f);
        for (DatabaseDiscoveryDataSourceRuleConfiguration each : dataSources) {
            result.put(each.getGroupName(), new DatabaseDiscoveryDataSourceRule(each, Strings.isNullOrEmpty((String)each.getDiscoveryHeartbeatName()) ? new Properties() : heartbeatConfig.get(each.getDiscoveryHeartbeatName()).getProps(), this.discoveryTypes.get(each.getDiscoveryTypeName())));
        }
        return result;
    }

    private void findMasterSlaveRelation(String databaseName, Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            String groupName = entry.getKey();
            DatabaseDiscoveryDataSourceRule dataSourceRule = entry.getValue();
            DatabaseDiscoveryEngine engine = new DatabaseDiscoveryEngine(dataSourceRule.getDatabaseDiscoveryProviderAlgorithm());
            HashMap<String, DataSource> originalDataSourceMap = new HashMap<String, DataSource>(dataSourceMap);
            engine.checkEnvironment(databaseName, originalDataSourceMap);
            dataSourceRule.changePrimaryDataSourceName(engine.changePrimaryDataSource(databaseName, groupName, entry.getValue().getPrimaryDataSourceName(), originalDataSourceMap, dataSourceRule.getDisabledDataSourceNames()));
        }
    }

    private void initAware() {
        DynamicDataSourceStrategyFactory.findInstance().ifPresent(optional -> optional.init((ShardingSphereRule)this));
    }

    public DatabaseDiscoveryDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<DatabaseDiscoveryDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.putAll(entry.getValue().getDataSourceMapper());
        }
        return result;
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        block4: {
            block3: {
                if (!(event instanceof DataSourceNameDisabledEvent)) break block3;
                for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                    if (((DataSourceNameDisabledEvent)event).isDisabled()) {
                        entry.getValue().disableDataSource(((DataSourceNameDisabledEvent)event).getQualifiedDatabase().getDataSourceName());
                        continue;
                    }
                    entry.getValue().enableDataSource(((DataSourceNameDisabledEvent)event).getQualifiedDatabase().getDataSourceName());
                }
                break block4;
            }
            if (!(event instanceof PrimaryDataSourceChangedEvent)) break block4;
            for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                if (!entry.getValue().getGroupName().equals(((PrimaryDataSourceChangedEvent)event).getQualifiedDatabase().getGroupName())) continue;
                entry.getValue().changePrimaryDataSourceName(((PrimaryDataSourceChangedEvent)event).getQualifiedDatabase().getDataSourceName());
            }
        }
    }

    public Map<String, Supplier<Object>> getExportedMethods() {
        return Collections.singletonMap("primary_data_source", this::exportPrimaryDataSourceMap);
    }

    private Map<String, String> exportPrimaryDataSourceMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.dataSourceRules.size(), 1.0f);
        this.dataSourceRules.forEach((name, dataSourceRule) -> result.put(dataSourceRule.getGroupName(), dataSourceRule.getPrimaryDataSourceName()));
        return result;
    }

    private void initHeartBeatJobs(InstanceContext instanceContext) {
        Optional modeScheduleContext = ModeScheduleContextFactory.getInstance().get(instanceContext.getInstance().getInstanceDefinition().getInstanceId());
        if (modeScheduleContext.isPresent()) {
            for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                DatabaseDiscoveryDataSourceRule rule = entry.getValue();
                Map<String, DataSource> dataSources = this.dataSourceMap.entrySet().stream().filter(each -> !rule.getDisabledDataSourceNames().contains(each.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                String jobName = rule.getDatabaseDiscoveryProviderAlgorithm().getType() + "-" + this.databaseName + "-" + rule.getGroupName();
                CronJob job = new CronJob(jobName, each -> new HeartbeatJob(this.databaseName, rule.getGroupName(), rule.getPrimaryDataSourceName(), dataSources, rule.getDatabaseDiscoveryProviderAlgorithm(), rule.getDisabledDataSourceNames()).execute(null), rule.getHeartbeatProps().getProperty("keep-alive-cron"));
                ((ModeScheduleContext)modeScheduleContext.get()).startCronJob(job);
            }
        }
    }

    public String getType() {
        return DatabaseDiscoveryRule.class.getSimpleName();
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        this.initHeartBeatJobs(instanceContext);
    }

    @Generated
    public Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules() {
        return this.dataSourceRules;
    }
}

