/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.algorithm;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.dbdiscovery.spi.ReplicaDataSourceStatus;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeRole;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceDisabledEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseDiscoveryEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseDiscoveryEngine.class);
    private final DatabaseDiscoveryProviderAlgorithm databaseDiscoveryProviderAlgorithm;

    public void checkEnvironment(String databaseName, Map<String, DataSource> dataSourceMap) {
        this.databaseDiscoveryProviderAlgorithm.checkEnvironment(databaseName, dataSourceMap.values());
    }

    public String changePrimaryDataSource(String databaseName, String groupName, String originalPrimaryDataSourceName, Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        Optional<String> newPrimaryDataSourceName = this.findPrimaryDataSourceName(dataSourceMap, disabledDataSourceNames);
        if (newPrimaryDataSourceName.isPresent() && !newPrimaryDataSourceName.get().equals(originalPrimaryDataSourceName)) {
            ShardingSphereEventBus.getInstance().post((Object)new PrimaryDataSourceChangedEvent(new QualifiedDatabase(databaseName, groupName, newPrimaryDataSourceName.get())));
        }
        String result = newPrimaryDataSourceName.orElse(originalPrimaryDataSourceName);
        this.postReplicaDataSourceDisabledEvent(databaseName, groupName, result, dataSourceMap);
        return result;
    }

    private Optional<String> findPrimaryDataSourceName(Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        for (Map.Entry<String, DataSource> entry : this.getActiveDataSourceMap(dataSourceMap, disabledDataSourceNames).entrySet()) {
            try {
                if (!this.databaseDiscoveryProviderAlgorithm.isPrimaryInstance(entry.getValue())) continue;
                return Optional.of(entry.getKey());
            }
            catch (SQLException ex) {
                log.error("An exception occurred while judge primary data source: ", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    private Map<String, DataSource> getActiveDataSourceMap(Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(dataSourceMap);
        if (!disabledDataSourceNames.isEmpty()) {
            result.entrySet().removeIf(each -> disabledDataSourceNames.contains(each.getKey()));
        }
        return result;
    }

    private void postReplicaDataSourceDisabledEvent(String databaseName, String groupName, String primaryDataSourceName, Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getKey().equals(primaryDataSourceName)) continue;
            ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(databaseName, groupName, entry.getKey(), this.createStorageNodeDataSource(this.loadReplicaStatus(entry.getValue()))));
        }
    }

    private StorageNodeDataSource createStorageNodeDataSource(ReplicaDataSourceStatus replicaStatus) {
        return new StorageNodeDataSource(StorageNodeRole.MEMBER, replicaStatus.isOnline() ? StorageNodeStatus.ENABLED : StorageNodeStatus.DISABLED, replicaStatus.getReplicationDelayMilliseconds());
    }

    private ReplicaDataSourceStatus loadReplicaStatus(DataSource replicaDataSource) {
        try {
            return this.databaseDiscoveryProviderAlgorithm.loadReplicaStatus(replicaDataSource);
        }
        catch (SQLException ex) {
            log.error("Load data source replica status error: ", (Throwable)ex);
            return new ReplicaDataSourceStatus(false, 0L);
        }
    }

    @Generated
    public DatabaseDiscoveryEngine(DatabaseDiscoveryProviderAlgorithm databaseDiscoveryProviderAlgorithm) {
        this.databaseDiscoveryProviderAlgorithm = databaseDiscoveryProviderAlgorithm;
    }
}

