/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.job;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.codec.binary.Hex;
import org.apache.shardingsphere.data.pipeline.api.job.AbstractJobId;

public final class RuleAlteredJobId
extends AbstractJobId {
    public static final String CURRENT_VERSION = "01";
    @NonNull
    private Integer currentMetadataVersion;
    @NonNull
    private Integer newMetadataVersion;

    public String marshal() {
        List<String> subTypes = this.getSubTypes();
        Collections.sort(subTypes);
        String text = this.getFormatVersion() + "|" + Joiner.on((char)'-').join(subTypes) + "|" + this.getCurrentMetadataVersion() + "T" + this.getNewMetadataVersion() + "|" + this.getSchemaName();
        return this.getType() + Hex.encodeHexString((byte[])text.getBytes(StandardCharsets.UTF_8), (boolean)true);
    }

    public static RuleAlteredJobId unmarshal(String hexText) {
        if (hexText.length() <= 2) {
            throw new IllegalArgumentException("Invalid hex text length, hexText=" + hexText);
        }
        String type = hexText.substring(0, 2);
        String text = new String(Hex.decodeHex((String)hexText.substring(2)), StandardCharsets.UTF_8);
        List splittedText = Splitter.on((char)'|').splitToList((CharSequence)text);
        String formatVersion = (String)splittedText.get(0);
        Preconditions.checkState((boolean)CURRENT_VERSION.equals(formatVersion), (Object)("Unknown formatVersion=" + formatVersion));
        List subTypes = Splitter.on((char)'-').splitToList((CharSequence)splittedText.get(1));
        List metadataVersions = Splitter.on((char)'T').splitToList((CharSequence)splittedText.get(2)).stream().map(Integer::parseInt).collect(Collectors.toList());
        String schemaName = (String)splittedText.get(3);
        RuleAlteredJobId result = new RuleAlteredJobId();
        result.setType(type);
        result.setFormatVersion(formatVersion);
        result.setSubTypes(subTypes);
        result.setCurrentMetadataVersion((Integer)metadataVersions.get(0));
        result.setNewMetadataVersion((Integer)metadataVersions.get(1));
        result.setSchemaName(schemaName);
        return result;
    }

    @NonNull
    @Generated
    public Integer getCurrentMetadataVersion() {
        return this.currentMetadataVersion;
    }

    @NonNull
    @Generated
    public Integer getNewMetadataVersion() {
        return this.newMetadataVersion;
    }

    @Generated
    public void setCurrentMetadataVersion(@NonNull Integer currentMetadataVersion) {
        if (currentMetadataVersion == null) {
            throw new NullPointerException("currentMetadataVersion is marked non-null but is null");
        }
        this.currentMetadataVersion = currentMetadataVersion;
    }

    @Generated
    public void setNewMetadataVersion(@NonNull Integer newMetadataVersion) {
        if (newMetadataVersion == null) {
            throw new NullPointerException("newMetadataVersion is marked non-null but is null");
        }
        this.newMetadataVersion = newMetadataVersion;
    }

    @Override
    @Generated
    public String toString() {
        return "RuleAlteredJobId(super=" + super.toString() + ", currentMetadataVersion=" + this.getCurrentMetadataVersion() + ", newMetadataVersion=" + this.getNewMetadataVersion() + ")";
    }
}

