/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.datasource.swapper;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.apache.shardingsphere.transaction.xa.jta.datasource.swapper.DataSourcePropertyProvider;
import org.apache.shardingsphere.transaction.xa.jta.datasource.swapper.impl.DefaultDataSourcePropertyProvider;

public final class DataSourcePropertyProviderLoader {
    private static final Map<String, DataSourcePropertyProvider> DATA_SOURCE_PROPERTY_PROVIDERS = new HashMap<String, DataSourcePropertyProvider>();

    public static DataSourcePropertyProvider getProvider(DataSource dataSource) {
        String dataSourceClassName = dataSource.getClass().getName();
        return DATA_SOURCE_PROPERTY_PROVIDERS.containsKey(dataSourceClassName) ? DATA_SOURCE_PROPERTY_PROVIDERS.get(dataSourceClassName) : new DefaultDataSourcePropertyProvider();
    }

    static {
        for (DataSourcePropertyProvider each : ServiceLoader.load(DataSourcePropertyProvider.class)) {
            DATA_SOURCE_PROPERTY_PROVIDERS.put(each.getDataSourceClassName(), each);
        }
    }
}

