/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingInsertValue;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class ShardingInsertValuesToken
extends InsertValuesToken
implements RouteUnitAware {
    public ShardingInsertValuesToken(int startIndex, int stopIndex) {
        super(startIndex, stopIndex);
    }

    public String toString(RouteUnit routeUnit) {
        StringBuilder result = new StringBuilder();
        this.appendInsertValue(routeUnit, result);
        result.delete(result.length() - 2, result.length());
        return result.toString();
    }

    private void appendInsertValue(RouteUnit routeUnit, StringBuilder stringBuilder) {
        for (InsertValue each : this.getInsertValues()) {
            if (!this.isAppend(routeUnit, (ShardingInsertValue)each)) continue;
            stringBuilder.append(each).append(", ");
        }
    }

    private boolean isAppend(RouteUnit routeUnit, ShardingInsertValue insertValueToken) {
        if (insertValueToken.getDataNodes().isEmpty() || null == routeUnit) {
            return true;
        }
        for (DataNode each : insertValueToken.getDataNodes()) {
            if (!routeUnit.findTableMapper(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }
}

